/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: BrainStem-all.h                                           //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: BrainStem API's and support.                       //
//                                                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2018 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/// All inclusive Header for C++ API access.

/**
 * This file can be included by users of the C++ API and includes all of
 * the necessary header files which represent the C++ API.
 */

#ifndef __BrainStem_all_H__
#define __BrainStem_all_H__

/////////////////////////////////////////////////////////////////////
/// Core Classes and type definitions for the BrainStem2 library. This
/// includes Link, Module, and the base Entity class.
#include "BrainStem-core.h"

/////////////////////////////////////////////////////////////////////
/// Contains concrete classes for each of the BrainStem Entity Types. This
/// includes System, Store, Analog, etc.
#include "BrainStem-entity.h"
#include "a40PinModule.h"
#include "aMTMStemModule.h"
#include "aEtherStem.h"
#include "aMTMDAQ1.h"
#include "aMTMEtherStem.h"
#include "aMTMIOSerial.h"
#include "aMTMPM1.h"
#include "aMTMLoad1.h"
#include "aMTMUSBStem.h"
#include "aUSBStem.h"
#include "aUSBHub2x4.h"
#include "aMTMRelay.h"
#include "aUSBHub3p.h"
#include "aUSBCSwitch.h"
#include "aUSBCSwitchPro.h"
#include "aUSBExt3c.h"
#include "aMTMDAQ2.h"
#include "aUSBHub3c.h"
#include "aPD3M.h"
#include "LocklessQueue_SPSC.h"
#include "PDChannelLogger.h"

#endif //__BrainStem_all_H__
