/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: aUSBCSwitchPro.h	 	  	                               //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: USBCSwitchPro C++ Module object.                   //
//                                                                 //
// build number: source                                            //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2018 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __aUSBCSwitchPro_H__
#define __aUSBCSwitchPro_H__

#include "BrainStem-all.h"
#include "aProtocoldefs.h"

/**
 * \defgroup aUSBCSwitchPro_Constants USBCSwitchPro Module Constants
 * @{
 */
#define aUSBCSWITCHPRO_MODULE                                     16  /**< USBCSwitchPro module number */

#define aUSBCSWITCHPRO_NUM_STORES                                  3 /**< Number of Store instances available */
#define   aUSBCSWITCHPRO_NUM_INTERNAL_SLOTS                        12 /**< Store: Number of internal slots instances available */
#define   aUSBCSWITCHPRO_NUM_RAM_SLOTS                             1 /**< Store: Number of RAM slot instances available */
#define   aUSBCSWITCHPRO_NUM_EEPROM_SLOTS                          8 /**< Store: Number of EEPROM slot instances available */
#define aUSBCSWITCHPRO_STORE_INTERNAL_INDEX                        0 /**< Store: Array index for internal store */
#define aUSBCSWITCHPRO_STORE_RAM_INDEX                             1 /**< Store: Array index for RAM store */
#define aUSBCSWITCHPRO_STORE_EEPROM_INDEX                          2 /**< Store: Array index for EEPROM store */

#define aUSBCSWITCHPRO_NUM_TEMPERATURES                            5 /**< Number of Temperature instances available */
#define aUSBCSWITCHPRO_NUM_USB                                     1 /**< Number of USB instances available */
#define aUSBCSWITCHPRO_NUM_USB_PORTS                               6 /**< Number of USB ports available */
#define aUSBCSWITCHPRO_NUM_PORTS                                   6 /**< Number of Ports available */
#define aUSBCSWITCHPRO_NUM_PD_PORTS                                6 /**< Number of PD compatible ports available */
#define aUSBCSWITCHPRO_NUM_PD_RULES_PER_PORT                       7 /**< Number of PD Rules per port available */
#define aUSBCSWITCHPRO_NUM_RAILS                                   1 /**< Number of Rail instances available */
#define aUSBCSWITCHPRO_NUM_I2C                                     1 /**< Number of I2C instances available */
#define aUSBCSWITCHPRO_NUM_UART                                    2 /**< Number of UART instances available */
#define aUSBCSWITCHPRO_NUM_MUX                                     1 /**< Number of Mux instances available */
#define   aUSBCSWITCHPRO_NUM_MUX_CHANNELS                          4 /**< Number of Mux channels available */
#define aUSBCSWITCHPRO_NUM_DIGITALS                                1 /**< Number of Digital instances available */
/** @} */


#if defined(__cplusplus)

///  \brief Concrete Module implementation of a USBCSwitchPro
///         Allows a user to connect to and control an attached switch
class aUSBCSwitchPro : public Acroname::BrainStem::Module
{
public:

    aUSBCSwitchPro(const uint8_t module = aUSBCSWITCHPRO_MODULE,
                bool bAutoNetworking = true,
                const uint8_t model = aMODULE_TYPE_USBC_Switch_Pro) :
    Acroname::BrainStem::Module(module, bAutoNetworking, model)
    {
        store[aUSBCSWITCHPRO_STORE_INTERNAL_INDEX].init(this, storeInternalStore);
        store[aUSBCSWITCHPRO_STORE_RAM_INDEX].init(this, storeRAMStore);
        store[aUSBCSWITCHPRO_STORE_EEPROM_INDEX].init(this, storeEEPROMStore);

        system.init(this, 0);

        for(int x = 0; x < aUSBCSWITCHPRO_NUM_TEMPERATURES; x++) {
            temperature[x].init(this, x);
        }

        for (int x = 0; x < aUSBCSWITCHPRO_NUM_PORTS; x++) {
            port[x].init(this, x);
        }

        for (int x = 0; x < aUSBCSWITCHPRO_NUM_PD_PORTS; x++) {
            pd[x].init(this, x);
        }

        mux.init(this, 0);

        for(int x = 0; x < aUSBCSWITCHPRO_NUM_RAILS; x++) {
            rail[x].init(this, x);
        }

        i2c[0].init(this, 0);

        for(int x = 0; x < aUSBCSWITCHPRO_NUM_UART; x++) {
            uart[x].init(this, x);
        }

        usb.init(this, 0);

        for(int x = 0; x < aUSBCSWITCHPRO_NUM_DIGITALS; x++) {
            digital[x].init(this, x);
        }
    }
    
    Acroname::BrainStem::PowerDeliveryClass pd[aUSBCSWITCHPRO_NUM_PD_PORTS]; /**< Power Delivery Class */
    Acroname::BrainStem::RailClass rail[aUSBCSWITCHPRO_NUM_RAILS]; /**< Rail Class */
    Acroname::BrainStem::StoreClass store[aUSBCSWITCHPRO_NUM_STORES]; /**< Store Class */
    Acroname::BrainStem::SystemClass system; /**< System Class */
    Acroname::BrainStem::TemperatureClass temperature[aUSBCSWITCHPRO_NUM_TEMPERATURES]; /**< Temperature Class */
    Acroname::BrainStem::I2CClass i2c[aUSBCSWITCHPRO_NUM_I2C]; /**< I2C Class */
    Acroname::BrainStem::USBClass usb; /**< USB Class */
    Acroname::BrainStem::UARTClass uart[aUSBCSWITCHPRO_NUM_UART]; /**< UART Class */
    Acroname::BrainStem::PortClass port[aUSBCSWITCHPRO_NUM_PORTS];
    Acroname::BrainStem::MuxClass mux; /**< Mux Class */
    Acroname::BrainStem::DigitalClass digital[aUSBCSWITCHPRO_NUM_DIGITALS]; /**< Digital Class */

    /** Port ID */
    typedef enum PORT_ID {
        kPORT_ID_0 = 0,
        kPORT_ID_1,
        kPORT_ID_2,
        kPORT_ID_3,
        kPORT_ID_COMMON,
        kPORT_ID_CONTROL
    } PORT_ID_t;
};

#endif//defined(__cplusplus)

#endif /* aUSBCSwitchPro_h */
