/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: aUSBExt3c.h    	 	  	                               //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: aUSBExt3c C++ Module object.                       //
//                                                                 //
// build number: source                                            //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2018 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __aUSBExt3c_H__
#define __aUSBExt3c_H__

#include "BrainStem-all.h"
#include "aProtocoldefs.h"

/**
 * \defgroup aUSBEXT3C_Constants USBCSwitchPro Module Constants
 * @{
 */
#define aUSBEXT3C_MODULE                    20 /**< USBExt3c module number */

#define aUSBEXT3C_NUM_STORES                3 /**< Number of Store instances available */
#define   aUSBEXT3C_NUM_INTERNAL_SLOTS      12 /**< Store: Number of internal slots instances available */
#define   aUSBEXT3C_NUM_RAM_SLOTS           1 /**< Store: Number of RAM slot instances available */
#define   aUSBEXT3C_NUM_EEPROM_SLOTS        8 /**< Store: Number of EEPROM slot instances available */
#define aUSBEXT3C_STORE_INTERNAL_INDEX      0 /**< Store: Array index for internal store */
#define aUSBEXT3C_STORE_RAM_INDEX           1 /**< Store: Array index for RAM store */
#define aUSBEXT3C_STORE_EEPROM_INDEX        2 /**< Store: Array index for EEPROM store */

#define aUSBEXT3C_NUM_TEMPERATURES          7 /**< Number of Temperature instances available */
#define aUSBEXT3C_NUM_USB                   1 /**< Number of USB instances available */
#define aUSBEXT3C_NUM_USB_PORTS             3 /**< Number of USB ports available */
#define aUSBEXT3C_NUM_PORTS                 4 /**< Number of Ports available */
#define aUSBEXT3C_NUM_PD_PORTS              3 /**< Number of PD compatible ports available */
#define aUSBEXT3C_NUM_PD_RULES_PER_PORT     7 /**< Number of PD Rules per port available */
#define aUSBEXT3C_NUM_UART                  7 /**< Number of UART instances available */
#define aUSBEXT3C_NUM_ETHERNET              1 /**< Number of Ethernet channels available */
#define aUSBEXT3C_NUM_POE                   1 /**< Number of POE channels available */
#define aUSBEXTEC_NUM_HDBASET               2 /**< Number of HDBaseT channels available*/
#define aUSBEXT3C_NUM_DIGITALS              2 /**< Number of Digital instances available */

/** @} */



#if defined(__cplusplus)

///  \brief Concrete Module implementation of a USBCSwitchPro
///         Allows a user to connect to and control an attached switch
class aUSBExt3c : public Acroname::BrainStem::Module
{
public:

    ///  \brief Hub class implementation for use with USBHub3c
    class HubClass : public Acroname::BrainStem::USBSystemClass {
    public:
        void init(Acroname::BrainStem::Module* pModule, const uint8_t index) {
            Acroname::BrainStem::USBSystemClass::init(pModule, index);
            for (int x = 0; x < aUSBEXT3C_NUM_PORTS; x++) {
                port[x].init(pModule, x);
            }
        }

        Acroname::BrainStem::PortClass port[aUSBEXT3C_NUM_PORTS];
    };


    aUSBExt3c(const uint8_t module = aUSBEXT3C_MODULE,
                bool bAutoNetworking = true,
                const uint8_t model = aMODULE_TYPE_USBExt3c) :
    Acroname::BrainStem::Module(module, bAutoNetworking, model)
    {
         for(int x = 0; x < aUSBEXT3C_NUM_PD_PORTS; x++) {
             pd[x].init(this, x);
         }

        store[aUSBEXT3C_STORE_INTERNAL_INDEX].init(this, storeInternalStore);
        store[aUSBEXT3C_STORE_RAM_INDEX].init(this, storeRAMStore);
        store[aUSBEXT3C_STORE_EEPROM_INDEX].init(this, storeEEPROMStore);

        system.init(this, 0);

        for(int x = 0; x < aUSBEXT3C_NUM_TEMPERATURES; x++) {
            temperature[x].init(this, x);
        }

        for(int x = 0; x < aUSBEXT3C_NUM_UART; x++) {
            uart[x].init(this, x);
        }

        usb.init(this, 0);

        ethernet.init(this, 0);

        poe.init(this, 0);

        for(int x = 0; x < aUSBEXTEC_NUM_HDBASET; x++) {
            hdbt[x].init(this, x);
        }

        hub.init(this, 0);

        for(int x = 0; x < aUSBEXT3C_NUM_DIGITALS; x++) {
            digital[x].init(this, x);
        }
    }

    HubClass hub; /**< Hub Class */
    Acroname::BrainStem::EthernetClass ethernet; /**< Ethernet Class */
    Acroname::BrainStem::HDBaseTClass hdbt[aUSBEXTEC_NUM_HDBASET]; /**< HDBaseT Class */
    Acroname::BrainStem::PoEClass poe; /**< POE Class */
    Acroname::BrainStem::PowerDeliveryClass pd[aUSBEXT3C_NUM_PD_PORTS]; /**< Power Delivery Class */
    Acroname::BrainStem::StoreClass store[aUSBEXT3C_NUM_STORES]; /**< Store Class */
    Acroname::BrainStem::SystemClass system; /**< System Class */
    Acroname::BrainStem::TemperatureClass temperature[aUSBEXT3C_NUM_TEMPERATURES]; /**< Temperature Class */
    Acroname::BrainStem::UARTClass uart[aUSBEXT3C_NUM_UART]; /**< UART Class */
    Acroname::BrainStem::USBClass usb; /**< USB Class */
    Acroname::BrainStem::DigitalClass digital[aUSBEXT3C_NUM_DIGITALS]; /**< Digital Class */

    /** Port ID */
    typedef enum PORT_ID {
        kPORT_ID_0 = 0,
        kPORT_ID_1,
        kPORT_ID_CONTROL,
        kPORT_ID_LAST
    } PORT_ID_t;

    typedef enum Temperature_Entity_Index {
        kTEMPERATURE_ENTITY_CH0_BUCK_BOOST = 0,
        kTEMPERATURE_ENTITY_CH1_BUCK_BOOST,
        kTEMPERATURE_ENTITY_CTRL_BUCK_BOOST,
        kTEMPERATURE_ENTITY_PD_STAGE,
        kTEMPERATURE_ENTITY_PSE_STAGE,
        kTEMPERATURE_ENTITY_PSE_CONTROLLER,
        kTEMPERATURE_ENTITY_VS6320,
    } Temperature_Entity_Index_t;

};

#endif//defined(__cplusplus)

#endif /* __aUSBExt3c_H__ */
