/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_AppClass_CPP.h                                    //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_APP_CPP_H__
#define __AUTOGEN_APP_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// AppClass:
/// Used to send a cmdAPP packet to the BrainStem network.
/// These commands are used for either host-to-stem or stem-to-stem interactions.
/// BrainStem modules can implement a reflex origin to complete an action when a cmdAPP packet
///   is addressed to the module.
/// 
class aLIBEXPORT AppClass : public EntityClass {

public:

    /// Constructor.
    AppClass(void);

    /// Destructor.
    virtual ~AppClass(void);

    /// Initialize the App Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the App entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Execute the app reflex on the module.
    /// Doesn't wait for a return value from the execute call; this call returns immediately upon
    ///   execution of the module's reflex.
    /// 
    /// \param appParam The app parameter handed to the reflex.
    /// 
    /// \retval aErrNone success.
    /// \retval aErrTimeout The request timed out waiting to start execution.
    /// \retval aErrConnection No active link connection.
    /// \retval aErrNotFound the app reflex was not found or not enabled on the module.
    aErr execute(const uint32_t appParam);

    /// Execute the app reflex on the module.
    /// Waits for a return from the reflex execution for msTimeout milliseconds.
    /// This method will block for up to msTimeout.
    /// 
    /// \param appParam The app parameter handed to the reflex.
    /// \param returnVal The return value filled in from the result of executing the reflex
    ///        routine.
    /// \param msTimeout The amount of time to wait for the return value from the reflex routine.
    ///        The default value is 1000 milliseconds if not specified.
    /// 
    /// \retval aErrNone - success.
    /// \retval aErrTimeout - The request timed out waiting for a response.
    /// \retval aErrConnection - No active link connection.
    /// \retval aErrNotFound - the app reflex was not found or not enabled on the module.
    aErr execute(const uint32_t appParam, uint32_t* returnVal, const uint32_t msTimeout = 1000);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_APP_CPP_H__