/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_ClockClass_CPP.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_CLOCK_CPP_H__
#define __AUTOGEN_CLOCK_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// ClockClass:
/// Provides an interface to a real-time clock entity on a BrainStem module.
/// The clock entity may be used to get and set the real time of the system.
/// The clock entity has a one second resolution.
/// 
/// \note Clock time must be reset if power to the BrainStem module is lost.
/// 
class aLIBEXPORT ClockClass : public EntityClass {

public:

    /// Constructor.
    ClockClass(void);

    /// Destructor.
    virtual ~ClockClass(void);

    /// Initialize the Clock Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Clock entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Get the four digit year value (0-4095).
    /// 
    /// \param year Get the year portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getYear(uint16_t* year);

    /// Set the four digit year value (0-4095).
    /// 
    /// \param year Set the year portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setYear(const uint16_t year);

    /// Get the two digit month value (1-12).
    /// 
    /// \param month The two digit month portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getMonth(uint8_t* month);

    /// Set the two digit month value (1-12).
    /// 
    /// \param month The two digit month portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setMonth(const uint8_t month);

    /// Get the two digit day of month value (1-28, 29, 30 or 31 depending on the month).
    /// 
    /// \param day The two digit day portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getDay(uint8_t* day);

    /// Set the two digit day of month value (1-28, 29, 30 or 31 depending on the month).
    /// 
    /// \param day The two digit day portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setDay(const uint8_t day);

    /// Get the two digit hour value (0-23).
    /// 
    /// \param hour The two digit hour portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getHour(uint8_t* hour);

    /// Set the two digit hour value (0-23).
    /// 
    /// \param hour The two digit hour portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setHour(const uint8_t hour);

    /// Get the two digit minute value (0-59).
    /// 
    /// \param minute The two digit minute portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getMinute(uint8_t* minute);

    /// Set the two digit minute value (0-59).
    /// 
    /// \param minute The two digit minute portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setMinute(const uint8_t minute);

    /// Get the two digit second value (0-59).
    /// 
    /// \param second The two digit second portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getSecond(uint8_t* second);

    /// Set the two digit second value (0-59).
    /// 
    /// \param second The two digit second portion of the real-time clock value.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setSecond(const uint8_t second);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_CLOCK_CPP_H__