/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RCServoClass_CPP.h                                //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RCSERVO_CPP_H__
#define __AUTOGEN_RCSERVO_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// RCServoClass:
/// Interface to servo entities on BrainStem modules.
/// Servo entities are built upon the digital input/output pins and therefore can also be
///   inputs or outputs.
/// Please see the product datasheet on the configuration limitations.
/// 
class aLIBEXPORT RCServoClass : public EntityClass {

public:

    /// Constructor.
    RCServoClass(void);

    /// Destructor.
    virtual ~RCServoClass(void);

    /// Initialize the RCServo Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the RCServo entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Enable the servo channel
    /// 
    /// \param enable The state to be set.
    ///        0 is disabled, 1 is enabled.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setEnable(const uint8_t enable);

    /// Get the enable status of the servo channel.
    /// 
    /// \param enable The current enable status of the servo entity.
    ///        0 is disabled, 1 is enabled.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getEnable(uint8_t* enable);

    /// Set the position of the servo channel
    /// 
    /// \param position The position to be set.
    ///        Default 64 = a 1ms pulse and 192 = a 2ms pulse.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setPosition(const uint8_t position);

    /// Get the position of the servo channel
    /// 
    /// \param position The current position of the servo channel.
    ///        Default 64 = a 1ms pulse and 192 = a 2ms pulse.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getPosition(uint8_t* position);

    /// Set the output to be reversed on the servo channel
    /// 
    /// \param reverse Reverses the value set by "setPosition".
    ///        For example, if the position is set to 64 (1ms pulse) the output will now be 192
    ///        (2ms pulse), however "getPostion" will return the set value of 64.
    ///        0 = not reversed, 1 = reversed.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setReverse(const uint8_t reverse);

    /// Get the reverse status of the servo channel
    /// 
    /// \param reverse The current reverse status of the servo entity.
    ///        0 = not reversed, 1 = reversed.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getReverse(uint8_t* reverse);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_RCSERVO_CPP_H__