/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_RelayClass_CPP.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_RELAY_CPP_H__
#define __AUTOGEN_RELAY_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// RelayClass:
/// Interface to relay entities on BrainStem modules.
/// Relay entities can be set, and the voltage read.
/// Other capabilities may be available, please see the product datasheet.
/// 
class aLIBEXPORT RelayClass : public EntityClass {

public:

    /// Constructor.
    RelayClass(void);

    /// Destructor.
    virtual ~RelayClass(void);

    /// Initialize the Relay Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Relay entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Set the enable/disable state.
    /// 
    /// \param enable False or 0 = Disabled, True or 1 = Enabled
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setEnable(const uint8_t enable);

    /// Get the state.
    /// 
    /// \param enabled False or 0 = Disabled, True or 1 = Enabled
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getEnable(uint8_t* enabled);

    /// Get the scaled micro volt value with reference to ground.
    /// 
    /// \param microvolts 32 bit signed integer (in micro Volts) based on the boards ground and
    ///        reference voltages.
    /// 
    /// \note Not all modules provide 32 bits of accuracy. Refer to the module's datasheet to
    ///       determine the analog bit depth and reference voltage.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getVoltage(int32_t* microvolts);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_RELAY_CPP_H__