/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_SignalClass_CPP.h                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_SIGNAL_CPP_H__
#define __AUTOGEN_SIGNAL_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// SignalClass:
/// Interface to digital pins configured to produce square wave signals.
/// This class is designed to allow for square waves at various frequencies and duty cycles.
/// Control is defined by specifying the wave period as (T3Time) and the active portion of the
///   cycle as (T2Time).
/// See the entity overview section of the reference for more detail regarding the timing.
/// 
class aLIBEXPORT SignalClass : public EntityClass {

public:

    /// Constructor.
    SignalClass(void);

    /// Destructor.
    virtual ~SignalClass(void);

    /// Initialize the Signal Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Signal entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Enable/Disable the signal output.
    /// 
    /// \param enable True to enable, false to disable
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setEnable(const uint8_t enable);

    /// Get the Enable/Disable of the signal.
    /// 
    /// \param enable True to enable, false to disable
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getEnable(uint8_t* enable);

    /// Invert the signal output.
    /// 
    /// Normal mode is High on t0 then low at t2.
    /// Inverted mode is Low at t0 on period start and high at t2.
    /// 
    /// \param invert True to invert, false for normal mode.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setInvert(const uint8_t invert);

    /// Get the invert status the signal output.
    /// 
    /// Normal mode is High on t0 then low at t2.
    /// Inverted mode is Low at t0 on period start and high at t2.
    /// 
    /// \param invert True to invert, false for normal mode.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getInvert(uint8_t* invert);

    /// Set the signal period or T3 in nanoseconds.
    /// 
    /// \param t3_nsec Integer not larger than unsigned 32 bit max value representing the wave
    ///        period in nanoseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setT3Time(const uint32_t t3_nsec);

    /// Get the signal period or T3 in nanoseconds.
    /// 
    /// \param t3_nsec Integer not larger than unsigned 32 bit max value representing the wave
    ///        period in nanoseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getT3Time(uint32_t* t3_nsec);

    /// Set the signal active period or T2 in nanoseconds.
    /// 
    /// \param t2_nsec Integer not larger than unsigned 32 bit max value representing the wave
    ///        active period in nanoseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setT2Time(const uint32_t t2_nsec);

    /// Get the signal active period or T2 in nanoseconds.
    /// 
    /// \param t2_nsec Integer not larger than unsigned 32 bit max value representing the wave
    ///        active period in nanoseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getT2Time(uint32_t* t2_nsec);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_SIGNAL_CPP_H__