/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_TimerClass_CPP.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_TIMER_CPP_H__
#define __AUTOGEN_TIMER_CPP_H__

#include "BrainStem-core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

#if defined(__cplusplus)

namespace Acroname {
namespace BrainStem {

/// TimerClass:
/// The Timer Class provides access to a simple scheduler.
/// The timer can set to fire only once, or to repeat at a certain interval.
/// Additionally, a timer entity can execute custom Reflex routines upon firing.
/// 
class aLIBEXPORT TimerClass : public EntityClass {

public:

    /// Constructor.
    TimerClass(void);

    /// Destructor.
    virtual ~TimerClass(void);

    /// Initialize the Timer Class.
    ///
    /// \param pModule The module to which this entity belongs.
    /// \param index The index of the Timer entity to be addressed.
    ///
    void init(Module* pModule, const uint8_t index);

    /// Get the currently set expiration time in microseconds.
    /// This is not a "live" timer. That is, it shows the expiration time originally set with
    ///   setExpiration; it does not "tick down" to show the time remaining before expiration.
    /// 
    /// \param usecDuration The timer expiration duration in microseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getExpiration(uint32_t* usecDuration);

    /// Set the expiration time for the timer entity.
    /// When the timer expires, it will fire the associated timer[index]() reflex.
    /// 
    /// \param usecDuration The duration before timer expiration in microseconds.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setExpiration(const uint32_t usecDuration);

    /// Get the mode of the timer which is either single or repeat mode.
    /// 
    /// \param mode The mode of the time. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr getMode(uint8_t* mode);

    /// Set the mode of the timer which is either single or repeat mode.
    /// 
    /// \param mode The mode of the timer. aTIMER_MODE_REPEAT or aTIMER_MODE_SINGLE.
    /// 
    /// \return Returns \ref EntityReturnValues "common entity" return values
    aErr setMode(const uint8_t mode);



};

} // namespace BrainStem
} // namespace Acroname

#endif // defined(__cplusplus)

#endif // __AUTOGEN_TIMER_CPP_H__