/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: aProtocoldefs.h                                           //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// description: Defines used for Brainstem communications.         //
//                                                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef _autoGen_aProtocolDefs_H_
#define _autoGen_aProtocolDefs_H_

#include "aError.h"

/////////////////////////////////////////////////////////////////////
/// BrainStem Protocol Definitions

/** \defgroup aProtocoldefs Protocol Defines
 * \ref aProtocoldefs "aProtocoldefs.h" Provides protocol and BrainStem
 * specific defines for entities, communication, and protocol specifics.
 */

/////////////////////////////////////////////////////////////////////
/// BrainStem model codes
#ifndef __aMODULE_DEF__
#define __aMODULE_DEF__

#define aMODULE_TYPE_USBStem_1                                      4
#define aMODULE_TYPE_EtherStem_1                                    5
#define aMODULE_TYPE_MTMIOSerial_1                                 13
#define aMODULE_TYPE_MTM_PM_1                                      14
#define aMODULE_TYPE_MTM_EtherStem                                 15
#define aMODULE_TYPE_MTM_USBStem                                   16
#define aMODULE_TYPE_USBHub2x4                                     17
#define aMODULE_TYPE_MTM_Relay                                     18
#define aMODULE_TYPE_USBHub3p                                      19
#define aMODULE_TYPE_MTM_DAQ_1                                     20
#define aMODULE_TYPE_USBC_Switch                                   21
#define aMODULE_TYPE_MTM_DAQ_2                                     22
#define aMODULE_TYPE_MTM_LOAD_1                                    23
#define aMODULE_TYPE_USBHub3c                                      24
#define aMODULE_TYPE_USBC_Switch_Pro                               25
#define aMODULE_TYPE_PD3M                                          26
#define aMODULE_TYPE_USBExt3c                                      27

#endif // __aMODULE_DEF__

#define START_PORT_SERVER_FRONTEND                              8000
#define START_PORT_SERVER_BACKEND                               91
#define DISCOVERY_BEACON_PORT                                   8585
#define LOCALHOST_IP_ADDRESS                                16777343

/////////////////////////////////////////////////////////////////////
/// **8 Bytes** - Packet protocol payload maximum.
#define aBRAINSTEM_MAXPACKETBYTES                                  28
#define aBRAINSTEM_MAX_POOLING_SIZE                              4096

/////////////////////////////////////////////////////////////////////
/// UEI and Command support for C/C++ and Reflex languages.

/** \defgroup UEI_Defines (UEI Specific Defines)
 *
 * @{
 */

/// **0x1F** - Mask bits for Index on index byte.
#define ueiSPECIFIER_INDEX_MASK                                  0x1F
/// **0xE0** -  Mask bits for Return value on index byte.
#define ueiSPECIFIER_RETURN_MASK                                 0xE0
/// **1 << 5** - Specifier Bit for UEI response to host.
#define ueiSPECIFIER_RETURN_HOST                                 0x20
/// **2 << 5** - Specifier Bit for UEI response to Module over I2C.
#define ueiSPECIFIER_RETURN_I2C                                  0x40
/// **3 << 5** - Specifier Bit for UEI response to VM on module.
#define ueiSPECIFIER_RETURN_VM                                   0x60
/// **1 << 7** - Error flag on response in index byte.
#define ueiREPLY_ERROR                                           0x80
/// **1 << 6** - Stream flag on response in index byte.
#define ueiREPLY_STREAM                                          0x40

/// **0x40** - Option byte code for UEI Get request.
#define ueiOPTION_GET                                            0x40
/// **0x00** - Option byte code for UEI Val response.
#define ueiOPTION_VAL                                            0x00
/// **0x80** - Option byte code for UEI Set request.
#define ueiOPTION_SET                                            0x80
/// **0xC0** - Option byte code for UEI Ack response.
#define ueiOPTION_ACK                                            0xC0
/// **0x3F** - Mask for getting command option from option byte.
#define ueiOPTION_MASK                                           0x3F
/// **0xC0** - Mask for getting Operation Get/Set/Val/Ack
#define ueiOPTION_OP_MASK                                        0xC0


#define ueiBYTES_CONTINUE                                        0x80
#define ueiBYTES_CONTINUE_MASK                                   0x7F
/** @} */

/////////////////////////////////////////////////////////////////////
// Command codes
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdANALOG_Defines Analog Command defines
 * Analog Command defines.
 *
 * @{
 */

/// **30** - Analog command code. 
#define cmdANALOG                                               30

/** \defgroup cmdANALOG_Command_Options Analog Command options
 * \ingroup cmdANALOG_Defines
 *
 * @{
 */

/// **1** - Analog Configuration Option Code
#define     analogConfiguration                                 1
/// **0** - Input configuration
#define         analogConfigurationInput                            0
/// **1** - Output configuration
#define         analogConfigurationOutput                           1
/// **2** - High Impedance configuration
#define         analogConfigurationHiZ                              2
/// **2** - Analog Value Option Code
#define     analogValue                                         2
/// **3** - Analog Voltage Option Code
#define     analogVoltage                                       3
/// **4** - Analog Bulk Capture Sample Rate Option Code
#define     analogBulkCaptureSampleRate                         4
/// **7000** - Minimum hertz sample rate
#define         analog_Hz_Minimum                                   7000
/// **200000** - Maximum hertz sample rate
#define         analog_Hz_Maximum                                   200000
/// **5** - Bulk Capture number of samples Option Code
#define     analogBulkCaptureNumberOfSamples                    5
/// **6** - Bulk Capture Option Code
#define     analogBulkCapture                                   6
/// **7** - Bulk Capture State Option Code
#define     analogBulkCaptureState                              7
/// **0** - Idle state
#define         bulkCaptureIdle                                     0
/// **1** - Pending state
#define         bulkCapturePending                                  1
/// **2** - Finished state
#define         bulkCaptureFinished                                 2
/// **3** - Error state
#define         bulkCaptureError                                    3
/// **8** - Analog Range Option Code
#define     analogRange                                         8
/// **0** - +/- 64mV range
#define         analogRange_P0V064N0V064                            0
/// **1** - +/- 640mV range
#define         analogRange_P0V64N0V64                              1
/// **2** - +/- 128mV range
#define         analogRange_P0V128N0V128                            2
/// **3** - +/- 1.28V range
#define         analogRange_P1V28N1V28                              3
/// **4** - 0-1.28V range
#define         analogRange_P1V28N0V0                               4
/// **5** - +/- 256mV range
#define         analogRange_P0V256N0V256                            5
/// **6** - +/- 2.56V range
#define         analogRange_P2V56N2V56                              6
/// **7** - 0-2.56V range
#define         analogRange_P2V56N0V0                               7
/// **8** - +/- 512mV range
#define         analogRange_P0V512N0V512                            8
/// **9** - +/- 5.12V range
#define         analogRange_P5V12N5V12                              9
/// **10** - 0-5.12V range
#define         analogRange_P5V12N0V0                               10
/// **11** - +/- 1.024V range
#define         analogRange_P1V024N1V024                            11
/// **12** - +/- 10.24V range
#define         analogRange_P10V24N10V24                            12
/// **13** - 0-10.24V range
#define         analogRange_P10V24N0V0                              13
/// **14** - 0-2.048V range
#define         analogRange_P2V048N0V0                              14
/// **15** - 0-4.096V range
#define         analogRange_P4V096N0V0                              15
/// **9** - Analog Enable Option Code
#define     analogEnable                                        9
/// **10** - Number of Options for analog, always last entry
#define     analogNumberOfOptions                               10

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdAPP_Defines App Command defines
 * App Command defines.
 *
 * @{
 */

/// **5** - App command code. 
#define cmdAPP                                                  5

/** \defgroup cmdAPP_Command_Options App Command options
 * \ingroup cmdAPP_Defines
 *
 * @{
 */

/// **1** - Execute Option Code
#define     appExecute                                          1
/// **2** - Return Option Code
#define     appReturn                                           2

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdCAPACITY_Defines Capacity Command defines
 * Capacity Command defines.
 *
 * @{
 */

/// **73** - Capacity command code. 
#define cmdCAPACITY                                             73

/** \defgroup cmdCAPACITY_Command_Options Capacity Command options
 * \ingroup cmdCAPACITY_Defines
 *
 * @{
 */

/// **1** - UEI Option Code
#define     capacityUEI                                         1
/// **3** - SubClass size Option Code
#define     capacitySubClassSize                                3
/// **4** - Class Quantity Option Code
#define     capacityClassQuantity                               4
/// **5** - SubClass Quantity Option Code
#define     capacitySubClassQuantity                            5
/// **6** - Entity Group Option Code
#define     capacityEntityGroup                                 6
/// **255** - Build Option Code
#define     capacityBuild                                       255

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdCLOCK_Defines Clock Command defines
 * Clock Command defines.
 *
 * @{
 */

/// **83** - Clock command code. 
#define cmdCLOCK                                                83

/** \defgroup cmdCLOCK_Command_Options Clock Command options
 * \ingroup cmdCLOCK_Defines
 *
 * @{
 */

/// **1** - Year Option Code
#define     clockYear                                           1
/// **2** - Month Option Code
#define     clockMonth                                          2
/// **3** - Day Option Code
#define     clockDay                                            3
/// **4** - Hour Option Code
#define     clockHour                                           4
/// **5** - Minute Option Code
#define     clockMinute                                         5
/// **6** - Second Option Code
#define     clockSecond                                         6
/// **7** - Number of Options for clock, always last entry
#define     clockNumberOfOptions                                7

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdDIGITAL_Defines Digital Command defines
 * Digital Command defines.
 *
 * @{
 */

/// **31** - Digital command code. 
#define cmdDIGITAL                                              31

/** \defgroup cmdDIGITAL_Command_Options Digital Command options
 * \ingroup cmdDIGITAL_Defines
 *
 * @{
 */

/// **1** - Digital configuration Option Code
#define     digitalConfiguration                                1
/// **0x00** - Input Configuration
#define         digitalConfigurationInput                           0x00
/// **0x01** - Output Configuration
#define         digitalConfigurationOutput                          0x01
/// **0x02** - RCServo Input Configuration
#define         digitalConfigurationRCServoInput                    0x02
/// **0x03** - RCServo Output Configuration
#define         digitalConfigurationRCServoOutput                   0x03
/// **0x04** - High Impedance Configuration
#define         digitalConfigurationHiZ                             0x04
/// **0x00** - Input Configuration with pull-up
#define         digitalConfigurationInputPullUp                     0x00
/// **0x04** - Input Configuration without pull-up/pull-down
#define         digitalConfigurationInputNoPull                     0x04
/// **0x05** - Input Configuration with pull-down
#define         digitalConfigurationInputPullDown                   0x05
/// **0x06** - Signal Output Configuration
#define         digitalConfigurationSignalOutput                    0x06
/// **0x07** - Signal Input Configuration
#define         digitalConfigurationSignalInput                     0x07
/// **0x08** - Signal Input Counter Configuration
#define         digitalConfigurationSignalCounterInput              0x08
/// **0x09** - Input from a linked digital channel
#define         digitalConfigurationLinkInput                       0x09
/// **0x0A** - Output to a linked digital channel
#define         digitalConfigurationLinkOutput                      0x0A
/// **2** - State Option Code
#define     digitalState                                        2
/// **3** - Full State Option Code
#define     digitalStateAll                                     3
/// **4** - Time Delay Option Code
#define     digitalTimeDelay                                    4
/// **5** - Value to set the pin to
#define     digitalValue                                        5
/// **6** - Link channel for linking digital entities
#define     digitalLinkChannel                                  6
/// **7** - Number of Options for digital, always last entry
#define     digitalNumberOfOptions                              7

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdEQUALIZER_Defines Equalizer Command defines
 * Equalizer Command defines.
 *
 * @{
 */

/// **15** - Equalizer command code. 
#define cmdEQUALIZER                                            15

/** \defgroup cmdEQUALIZER_Command_Options Equalizer Command options
 * \ingroup cmdEQUALIZER_Defines
 *
 * @{
 */

/// **1** - Receiver Configuration Option Code
#define     equalizerReceiverConfig                             1
/// **2** - Transmitter (Driver) Configuration Option Code
#define     equalizerTransmitterConfig                          2
/// **3** - Manual Configuration Option Code
#define     equalizerManualConfig                               3
/// **4** - Number of Options for equalizer, always last entry
#define     equalizerNumberOfOptions                            4

/** @} */

/** \defgroup cmdEQUALIZER_Command_Constants Equalizer Command constants
 * \ingroup cmdEQUALIZER_Defines
 *
 * @{
 */

/// Equalizer Index for USB2.0
#define     equalizer2p0                                        0
/// Equalizer Index for USB3.0
#define     equalizer3p0                                        1
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdETHERNET_Defines Ethernet Command defines
 * Ethernet Command defines.
 *
 * @{
 */

/// **39** - Ethernet command code. 
#define cmdETHERNET                                             39

/** \defgroup cmdETHERNET_Command_Options Ethernet Command options
 * \ingroup cmdETHERNET_Defines
 *
 * @{
 */

/// **1** - Enabled
#define     ethernetEnabled                                     1
/// **2** - Network IP Assignment Configuration
#define     ethernetNetworkConfiguration                        2
/// **0** - Disable IP Assignment Option Code
#define         ethernetConfigurationNone                           0
/// **1** - Static IP Address Option Code
#define         ethernetConfigurationStatic                         1
/// **2** - DHCP Address Option Code
#define         ethernetConfigurationDhcp                           2
/// **3** - Static IP Address
#define     ethernetStaticIPv4Address                           3
/// **4** - Static IP Netmask
#define     ethernetStaticIPv4Netmask                           4
/// **5** - Static IP Gateway
#define     ethernetStaticIPv4Gateway                           5
/// **6** - Current IP Address
#define     ethernetIPv4Address                                 6
/// **7** - Current IP Netmask
#define     ethernetIPv4Netmask                                 7
/// **8** - Current IP Gateway
#define     ethernetIPv4Gateway                                 8
/// **9** - Static DNS Address
#define     ethernetStaticIPv4DNSAddress                        9
/// **10** - Current DNS Address
#define     ethernetIPv4DNSAddress                              10
/// **11** - Hostname
#define     ethernetHostname                                    11
/// **12** - MAC Address
#define     ethernetMACAddress                                  12
/// **13** - Port number of TCPIP Interface
#define     ethernetInterfacePort                               13
/// **0** - REST Service (HTTP) Port
#define         ethernetInterfacePort_RestServer_HTTP               0
/// **1** - REST Service (HTTP) Port
#define         ethernetInterfacePort_RestServer_HTTPS              1
/// **2** - BrainStem TCPIP Transport Port
#define         ethernetInterfacePort_BrainStem_TCP                 2
/// **3** - BrainStem Multicast Discovery Request Port
#define         ethernetInterfacePort_BrainStem_DiscoveryRequest    3
/// **4** - BrainStem Multicast Discovery Reply Port
#define         ethernetInterfacePort_BrainStem_DiscoveryReply      4
/// **5** - Number of options for ethernetInterfacePort
#define         ethernetInterfacePort_Max                           5
/// **14** - Number of Options for ethernet, always last entry
#define     ethernetNumberOfOptions                             14

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdFACTORY_Defines Factory Command defines
 * Factory Command defines.
 *
 * @{
 */

/// **94** - Factory command code.  For internal use only.
#define cmdFACTORY                                              94

/** \defgroup cmdFACTORY_Command_Options Factory Command options
 * \ingroup cmdFACTORY_Defines
 *
 * @{
 */

/// **1** - Internal factory Option Code
#define     factoryCommand1_Value                               1
/// **2** - Internal factory Option Code
#define     factoryCommand2_Value                               2
/// **3** - Internal factory Option Code
#define     factoryCommand3_Value                               3
/// **4** - Internal factory Option Code
#define     factoryCommand4_Value                               4
/// **5** - Internal factory Option Code
#define     factoryCommand5_Value                               5
/// **6** - Internal factory Option Code
#define     factoryCommand6_Value                               6
/// **7** - Internal factory Option Code
#define     factoryCommand7_Value                               7
/// **8** - Internal factory Option Code
#define     factoryCommand8_Value                               8
/// **9** - Internal factory Option Code
#define     factoryCommand9_Value                               9
/// **10** - Internal factory Option Code
#define     factoryCommand10_Value                              10
/// **11** - Internal factory Option Code
#define     factoryCommand11_Value                              11
/// **12** - Internal factory Option Code
#define     factoryCommand12_Value                              12
/// **13** - Internal factory Option Code
#define     factoryCommand13_Value                              13
/// **14** - Number of Options for factory, always last entry
#define     factoryNumberOfCommands                             14

/** @} */

/** \defgroup cmdFACTORY_Command_Constants Factory Command constants
 * \ingroup cmdFACTORY_Defines
 *
 * @{
 */

#define     factoryError_Bit                                    7
#define     factoryStart_Bit                                    6
#define     factoryEnd_Bit                                      5
#define     factorySet_Bit                                      4
#define     cmdFACTORY_UEI                                      96
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////

/** \defgroup General_Defines General Definitions
 *
 * @{
 */

/// Debug Command
#define     cmdDEBUG                                            23
/// Notify Command
#define     cmdNOTIFY                                           24
/// Maximum Command
#define     cmdLAST                                             96
 

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdHDBASET_Defines HDBaseT Command defines
 * HDBaseT Command defines.
 *
 * @{
 */

/// **41** - HDBaseT command code. 
#define cmdHDBASET                                              41

/** \defgroup cmdHDBASET_Command_Options HDBaseT Command options
 * \ingroup cmdHDBASET_Defines
 *
 * @{
 */

/// **1** - Serial Number Option Code
#define     hdbasetSerialNumber                                 1
/// **2** - Firmware Version Option Code
#define     hdbasetFirmwareVersion                              2
/// **3** - State Option Code
#define     hdbasetState                                        3
/// **0** - Device Present Bit
#define         hdbasetState_devicePresent_Bit                      0
/// **1** - Link Up Bit
#define         hdbasetState_linkUp_Bit                             1
/// **2** - Link Role Offset
#define         hdbasetState_linkRole_Offset                        2
/// **0x3** - Link Role Mask
#define             hdbasetState_linkRole_Mask                          0x3
/// **0** - Unknown Link Role
#define             hdbasetState_linkRole_Unknown                       0
/// **1** - Leader/Master Link Role
#define             hdbasetState_linkRole_Leader                        1
/// **2** - Follower/Slave Link Role
#define             hdbasetState_linkRole_Follower                      2
/// **4** - Cable Length Option Code
#define     hdbasetCableLength                                  4
/// **5** - Mean Squared Error Pair A Option Code
#define     hdbasetMSEA                                         5
/// **6** - Mean Squared Error Pair B Option Code
#define     hdbasetMSEB                                         6
/// **7** - Retransmission Rate Option Code
#define     hdbasetRetransmissionRate                           7
/// **8** - Link Utilization Option Code
#define     hdbasetLinkUtilization                              8
/// **9** - HDBaseT Encoding State Option Code
#define     hdbasetEncodingState                                9
/// **0** - Unknown
#define         hdbasetEncodingState_Unknown                        0
/// **1** - PAM16
#define         hdbasetEncodingState_PAM16                          1
/// **2** - PAM8
#define         hdbasetEncodingState_PAM8                           2
/// **3** - PAM4
#define         hdbasetEncodingState_PAM4                           3
/// **10** - USB2 Device Tree Option Code
#define     hdbasetUSB2DeviceTree                               10
/// **11** - USB3 Device Tree Option Code
#define     hdbasetUSB3DeviceTree                               11
/// **12** - Link Role Option Code
#define     hdbasetLinkRole                                     12
/// **0** - Auto-Detected Link Role
#define         hdbasetLinkRole_AutoDetect                          0
/// **1** - Leader/Master Link Role
#define         hdbasetLinkRole_Leader                              1
/// **2** - Follower/Slave Link Role
#define         hdbasetLinkRole_Follower                            2
/// **13** - Number of Options for HDBaseT, always last entry
#define     hdbasetNumberOfOptions                              13

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdHB_Defines Heartbeat Command defines
 * Heartbeat Command defines.
 *
 * @{
 */

/// **0** - Heartbeat command code. 
#define cmdHB                                                   0


/** \defgroup cmdHB_Command_Constants Heartbeat Command constants
 * \ingroup cmdHB_Defines
 *
 * @{
 */

#define     val_HB_S2H_UP                                       0
#define     val_HB_S2H_DOWN                                     1
#define     val_HB_H2S_UP                                       2
#define     val_HB_H2S_DOWN                                     3
#define     val_HB_M2R_UP                                       4
#define     val_HB_M2R_DOWN                                     5
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdI2C_Defines I2C Command defines
 * I2C Command defines.
 *
 * @{
 */

/// **8** - I2C command code. 
#define cmdI2C                                                  8

/** \defgroup cmdI2C_Command_Options I2C Command options
 * \ingroup cmdI2C_Defines
 *
 * @{
 */

/// **1** - Set Pullup Option Code
#define     i2cSetPullup                                        1

/** @} */

/** \defgroup cmdI2C_Command_Constants I2C Command constants
 * \ingroup cmdI2C_Defines
 *
 * @{
 */

/// Default I2C Speed Setting
#define     i2cDefaultSpeed                                     0
/// 100kHz I2C Speed Setting
#define     i2cSpeed_100Khz                                     1
/// 400kHz I2C Speed Setting
#define     i2cSpeed_400Khz                                     2
/// 1000kHz I2C Speed Setting
#define     i2cSpeed_1000Khz                                    3
/// Bit I2C error code
#define     bitI2CError                                         0x80
/// Bit I2C ack code
#define     bitI2CAck                                           0x40
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdMUX_Defines Mux Command defines
 * Mux Command defines.
 *
 * @{
 */

/// **6** - Mux command code. 
#define cmdMUX                                                  6

/** \defgroup cmdMUX_Command_Options Mux Command options
 * \ingroup cmdMUX_Defines
 *
 * @{
 */

/// **1** - Channel Enable Option Code
#define     muxEnable                                           1
/// **2** - Channel Select Option Code
#define     muxChannel                                          2
/// **3** - Channel Voltage Measurement Option Code
#define     muxVoltage                                          3
/// **4** - Mux Mode Configuration Option Code
#define     muxConfig                                           4
/// **0** - Default (Manual)
#define         muxConfig_default                                   0
/// **1** - Split Mode
#define         muxConfig_splitMode                                 1
/// **2** - Channel Pririty
#define         muxConfig_channelpriority                           2
/// **5** - Split Mode Configuration Option Code
#define     muxSplit                                            5
/// **6** - Number of Options for mux, always last entry
#define     muxNumberOfOptions                                  6

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdPOE_Defines POE Command defines
 * POE Command defines.
 *
 * @{
 */

/// **40** - POE command code. 
#define cmdPOE                                                  40

/** \defgroup cmdPOE_Command_Options POE Command options
 * \ingroup cmdPOE_Defines
 *
 * @{
 */

/// **1** - Power Mode Option Code
#define     poePowerMode                                        1
#define         poePowerMode_Off                                    0
#define         poePowerMode_PSE                                    1
#define         poePowerMode_PD                                     2
#define         poePowerMode_Auto                                   3
/// **2** - Power State Option Code
#define     poePowerState                                       2
#define         poePowerState_Off                                   0
#define         poePowerState_PSE                                   1
#define         poePowerState_PD                                    2
/// **3** - Pair Enabled Option Code
#define     poePairEnabled                                      3
/// **4** - Pair Sourcing Class Option Code
#define     poePairSourcingClass                                4
#define         poePairSourcingClass_Unknown                        0
#define         poePairSourcingClass_0                              1
#define         poePairSourcingClass_1                              2
#define         poePairSourcingClass_2                              3
#define         poePairSourcingClass_3                              4
#define         poePairSourcingClass_4                              5
#define         poePairSourcingClass_4_PlusType1Limited             6
#define         poePairSourcingClass_5_4PairSingleSignature         7
#define         poePairSourcingClass_5_4PairDualSignature           8
#define         poePairSourcingClass_6_4PairSingleSignature         9
#define         poePairSourcingClass_7_4PairSingleSignature         10
#define         poePairSourcingClass_8_4PairSingleSignature         11
#define         poePairSourcingClass_Mismatch                       12
#define         poePairSourcingClass_OverCurrent                    13
/// **5** - Pair Requested Class Option Code
#define     poePairRequestedClass                               5
#define         poePairRequestedClass_Unknown                       0
#define         poePairRequestedClass_0                             1
#define         poePairRequestedClass_1                             2
#define         poePairRequestedClass_2                             3
#define         poePairRequestedClass_3                             4
#define         poePairRequestedClass_4                             5
#define         poePairRequestedClass_4_PlusType1Limited            6
#define         poePairRequestedClass_5_4PairSingleSignature        7
#define         poePairRequestedClass_5_4PairDualSignature          8
#define         poePairRequestedClass_6_4PairSingleSignature        9
#define         poePairRequestedClass_7_4PairSingleSignature        10
#define         poePairRequestedClass_8_4PairSingleSignature        11
#define         poePairRequestedClass_Mismatch                      12
#define         poePairRequestedClass_OverCurrent                   13
/// **6** - Pair Discovered Class Option Code
#define     poePairDiscoveredClass                              6
#define         poePairDiscoveredClass_Unknown                      0
#define         poePairDiscoveredClass_0                            1
#define         poePairDiscoveredClass_1                            2
#define         poePairDiscoveredClass_2                            3
#define         poePairDiscoveredClass_3                            4
#define         poePairDiscoveredClass_4                            5
#define         poePairDiscoveredClass_4_PlusType1Limited           6
#define         poePairDiscoveredClass_5_4PairSingleSignature       7
#define         poePairDiscoveredClass_5_4PairDualSignature         8
#define         poePairDiscoveredClass_6_4PairSingleSignature       9
#define         poePairDiscoveredClass_7_4PairSingleSignature       10
#define         poePairDiscoveredClass_8_4PairSingleSignature       11
#define         poePairDiscoveredClass_Mismatch                     12
#define         poePairDiscoveredClass_OverCurrent                  13
/// **7** - Pair Detection Status Option Code
#define     poePairDetectionStatus                              7
#define         poePairDetectionStatus_Unknown                      0
#define         poePairDetectionStatus_Short_Circuit                1
#define         poePairDetectionStatus_Open_Circuit                 2
#define         poePairDetectionStatus_Low_Resistance               3
#define         poePairDetectionStatus_High_Resistance              4
#define         poePairDetectionStatus_Valid                        5
#define         poePairDetectionStatus_Switch_Failure               6
/// **8** - Pair Voltage Option Code
#define     poePairVoltage                                      8
/// **9** - Pair Current Option Code
#define     poePairCurrent                                      9
/// **10** - Pair Power Option Code
#define     poePairPower                                        10
/// **11** - Combined Pair Power Option Code
#define     poeTotalPower                                       11
/// **12** - Pair Accumulated Power Option Code
#define     poePairAccumulatedPower                             12
/// **13** - Combined Pair Accumulated Power Option Code
#define     poeTotalAccumulatedPower                            13
/// **14** - Pair Resistance Option Code
#define     poePairResistance                                   14
/// **15** - Pair Capacitance Option Code
#define     poePairCapacitance                                  15
/// **16** - Number of Options for POE, always last entry
#define     poeNumberOfOptions                                  16

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdPOINTER_Defines Pointer Command defines
 * Pointer Command defines.
 *
 * @{
 */

/// **7** - Pointer command code. 
#define cmdPOINTER                                              7

/** \defgroup cmdPOINTER_Command_Options Pointer Command options
 * \ingroup cmdPOINTER_Defines
 *
 * @{
 */

/// **1** - Offset Option Code
#define     pointerOffset                                       1
/// **2** - Mode Option Code
#define     pointerMode                                         2
/// **0** - Static Mode
#define         pointerModeStatic                                   0
/// **1** - Increment Mode
#define         pointerModeIncrement                                1
/// **0** - Default Mode
#define         pointerModeDefault                                  0
/// **3** - Set Transfer Store Option Code
#define     pointerTransferStore                                3
/// **4** - Char Option Code
#define     pointerChar                                         4
/// **5** - Short Option Code
#define     pointerShort                                        5
/// **6** - Integer Option Code
#define     pointerInt                                          6
/// **7** - Transfer to Store Option Code
#define     pointerTransferToStore                              7
/// **8** - Transfer From Store Option Code
#define     pointerTransferFromStore                            8

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdPORT_Defines Port Command defines
 * Port Command defines.
 *
 * @{
 */

/// **37** - Port command code. 
#define cmdPORT                                                 37

/** \defgroup cmdPORT_Command_Options Port Command options
 * \ingroup cmdPORT_Defines
 *
 * @{
 */

/// **1** - Vbus Voltage Option Code
#define     portVbusVoltage                                     1
/// **2** - Vbus Current Option Code
#define     portVbusCurrent                                     2
/// **3** - Vconn Voltage Option Code
#define     portVconnVoltage                                    3
/// **4** - Vconn Current Option Code
#define     portVconnCurrent                                    4
/// **5** - Port Enabled Option Code
#define     portPortEnabled                                     5
/// **6** - Port Power Enabled Option Code
#define     portPowerEnabled                                    6
/// **7** - Port Data Enabled Option Code
#define     portDataEnabled                                     7
/// **8** - Port HS Data Enabled Option Code
#define     portDataHSEnabled                                   8
/// **9** - Port HS1 Data Enabled Option Code
#define     portDataHS1Enabled                                  9
/// **10** - Port HS2 Data Enabled Option Code
#define     portDataHS2Enabled                                  10
/// **11** - Port SS Data Enabled Option Code
#define     portDataSSEnabled                                   11
/// **12** - Port SS1 Data Enabled Option Code
#define     portDataSS1Enabled                                  12
/// **13** - Port SS2 Data Enabled Option Code
#define     portDataSS2Enabled                                  13
/// **14** - CC Enabled Option Code
#define     portCCEnabled                                       14
/// **15** - CC1 Enabled Option Code
#define     portCC1Enabled                                      15
/// **16** - CC2 Enabled Option Code
#define     portCC2Enabled                                      16
/// **17** - Vconn Enabled Option Code
#define     portVconnEnabled                                    17
/// **18** - Vconn1 Enabled Option Code
#define     portVconn1Enabled                                   18
/// **19** - Vconn2 Enabled Option Code
#define     portVconn2Enabled                                   19
/// **20** - Port State Option Code
#define     portPortState                                       20
/// **0** - Power enable bit
#define         portPortState_powerEnabled_Bit                      0
/// **1** - USB 2.0 (HS) 1 side enable bit.
#define         portPortState_HS1Enabled_Bit                        1
/// **2** - USB 2.0 (HS) 2 side enable bit
#define         portPortState_HS2Enabled_Bit                        2
/// **3** - USB 3.0 (SS) 1 side enable bit
#define         portPortState_SS1Enabled_Bit                        3
/// **4** - USB 3.0 (SS) 2 side enable bit
#define         portPortState_SS2Enabled_Bit                        4
/// **5** - CC 1 enable bit
#define         portPortState_CC1Enabled_Bit                        5
/// **6** - CC 2 enable bit
#define         portPortState_CC2Enabled_Bit                        6
/// **7** - VConn 1 enable bit
#define         portPortState_Vconn1Enabled_Bit                     7
/// **8** - VConn 2 enable bit
#define         portPortState_Vconn2Enabled_Bit                     8
/// **9** - SBU 1 enable bit
#define         portPortState_SBU1Enabled_Bit                       9
/// **10** - SBU 2 enable bit
#define         portPortState_SBU2Enabled_Bit                       10
/// **11** - CC Flipped bit
#define         portPortState_CC_Flipped_Bit                        11
/// **12** - HS Flipped bit
#define         portPortState_HS_Flipped_Bit                        12
/// **13** - SS Flipped bit
#define         portPortState_SS_Flipped_Bit                        13
/// **14** - SBU Flipped bit
#define         portPortState_SBU_Flipped_Bit                       14
/// **15** - KAC Enabled bit
#define         portPortState_KACEnabled_Bit                        15
/// **21** - Port Errors Option Code
#define     portErrors                                          21
/// **22** - Port Current Limit. Option Code
#define     portCurrentLimit                                    22
/// **23** - Port Current Limit Mode. Option Code
#define     portCurrentLimitMode                                23
/// **24** - Port Power Limit. Option Code
#define     portPowerLimit                                      24
/// **25** - Port Power Limit Mode. Option Code
#define     portPowerLimitMode                                  25
/// **26** - Port available power Option Code
#define     portAvailablePower                                  26
/// **27** - Port Name Option Code
#define     portName                                            27
/// **28** - Port CC Current Limit Option Code
#define     portCCCurrentLimit                                  28
/// **0** - None Current value
#define         portCCCurrentLimit_None                             0
/// **1** - Default Current value (500/900mA)
#define         portCCCurrentLimit_Default                          1
/// **2** - 1.5 Amp Current value
#define         portCCCurrentLimit_1p5                              2
/// **3** - 3.0 Amp Current value
#define         portCCCurrentLimit_3p0                              3
/// **30** - Port Power mode Option Code
#define     portPowerMode                                       30
/// **0** - None/Disabled
#define         portPowerMode_none_Value                            0
/// **1** - Standard Downstream Port (SDP)
#define         portPowerMode_sdp_Value                             1
/// **2** - Charging Downstream Port (CDP) or Dedicated Charging Port (DCP)
#define         portPowerMode_cdp_dcp_Value                         2
/// **3** - Qualcom Quick Charge (QC)
#define         portPowerMode_qc_Value                              3
/// **4** - Power Delivery (PD)
#define         portPowerMode_pd_Value                              4
/// **5** - Power Supply Mode
#define         portPowerMode_ps_Value                              5
/// **6** - USB-C Mode
#define         portPowerMode_usbc_Value                            6
/// **31** - Port Data Role Option Code
#define     portDataRole                                        31
/// **0** - Role - Disabled
#define         portDataRole_Disabled_Value                         0
/// **1** - Role - Upstream Port
#define         portDataRole_Upstream_Value                         1
/// **2** - Role:Downstream Port
#define         portDataRole_Downstream_Value                       2
/// **3** - Role:Control Port
#define         portDataRole_Control_Value                          3
/// **32** - Port Data Speed Option Code
#define     portDataSpeed                                       32
/// **0** - Speed - Low Speed (1.5Mbps) bit indicator
#define         portDataSpeed_ls_1p5M_Bit                           0
/// **1** - Speed - Full Speed (12Mbps) bit indicator
#define         portDataSpeed_fs_12M_Bit                            1
/// **2** - Speed - High Speed (480Mbps) bit indicator
#define         portDataSpeed_hs_480M_Bit                           2
/// **3** - Speed - Super Speed (5Gbps) bit indicator
#define         portDataSpeed_ss_5G_Bit                             3
/// **4** - Speed - Super Speed Plus (10Gbps) bit indicator
#define         portDataSpeed_ss_10G_Bit                            4
/// **6** - USB 2.0 Connected
#define         portDataSpeed_Connected_2p0_Bit                     6
/// **7** - USB 3.0 Connected
#define         portDataSpeed_Connected_3p0_Bit                     7
/// **33** - Port Mode Option Code
#define     portPortMode                                        33
/// **0** - Power enable bit
#define         portPortMode_powerEnabled_Bit                       0
/// **1** - USB 2.0 (HS) 1 side enable bit.
#define         portPortMode_HS1Enabled_Bit                         1
/// **2** - USB 2.0 (HS) 2 side enable bit
#define         portPortMode_HS2Enabled_Bit                         2
/// **3** - USB 3.0 (SS) 1 side enable bit
#define         portPortMode_SS1Enabled_Bit                         3
/// **4** - USB 3.0 (SS) 2 side enable bit
#define         portPortMode_SS2Enabled_Bit                         4
/// **5** - CC 1 enable bit
#define         portPortMode_CC1Enabled_Bit                         5
/// **6** - CC 2 enable bit
#define         portPortMode_CC2Enabled_Bit                         6
/// **7** - VCONN 1 enable bit
#define         portPortMode_Vconn1Enabled_Bit                      7
/// **8** - VCONN 2 enable bit
#define         portPortMode_Vconn2Enabled_Bit                      8
/// **9** - SBU 1 enable bit
#define         portPortMode_SBU1Enabled_Bit                        9
/// **10** - SBU 2 enable bit
#define         portPortMode_SBU2Enabled_Bit                        10
/// **11** - HS Flipped bit
#define         portPortMode_HSFlipEnabled_Bit                      11
/// **12** - SS Flipped bit
#define         portPortMode_SSFlipEnabled_Bit                      12
/// **13** - CC Flipped bit
#define         portPortMode_CCFlipEnabled_Bit                      13
/// **14** - SBU Flipped bit
#define         portPortMode_SBUFlipEnabled_Bit                     14
/// **15** - KAC Enabled bit
#define         portPortMode_KACEnabled_Bit                         15
/// **16** - Port Power Mode offset within Port Mode
#define         portPortMode_portPowerMode_Offset                   16
/// **0x7** - Port Power Mode offset (Pre offset shift)
#define             portPortMode_portPowerMode_Mask                     0x7
/// **0** - Port Power None/Disabled
#define             portPortMode_portPowerMode_none_Value               0
/// **1** - Port Power Standard Downstream Port (SDP)
#define             portPortMode_portPowerMode_sdp_Value                1
/// **2** - Charging Downstream Port (CDP) or Dedicated Charging Port (DCP)
#define             portPortMode_cdp_dcp_Value                          2
/// **3** - Port Power Qualcom Quick Charge (QC)
#define             portPortMode_portPowerMode_qc_Value                 3
/// **4** - Port Power Power Delivery (PD)
#define             portPortMode_portPowerMode_pd_Value                 4
/// **5** - Port Power Power Supply Mode
#define             portPortMode_portPowerMode_ps_Value                 5
/// **6** - Port Power USB-C Mode
#define             portPortMode_portPowerMode_usbc_Value               6
/// **34** - Port Voltage Setpoint for VBUS Override Option Code
#define     portVoltageSetpoint                                 34
/// **35** - Port Allocated Power Option Code
#define     portAllocatedPower                                  35
/// **36** - Port Change HighSpeed Data Signal Routing Behavior Option Code
#define     portDataHSRoutingBehavior                           36
/// **0** - Auto Follow CC
#define         portDataHSRoutingBehavior_FollowCC                  0
/// **1** - Side 1 Only
#define         portDataHSRoutingBehavior_Side1                     1
/// **2** - Side 2 Only
#define         portDataHSRoutingBehavior_Side2                     2
/// **3** - Side 1 and 2 Shorted
#define         portDataHSRoutingBehavior_Shorted                   3
/// **37** - Port Change SuperSpeed Data Signal Routing Behavior Option Code
#define     portDataSSRoutingBehavior                           37
/// **0** - Auto Follow CC
#define         portDataSSRoutingBehavior_FollowCC                  0
/// **1** - Side 1 Only
#define         portDataSSRoutingBehavior_Side1                     1
/// **2** - Side 2 Only
#define         portDataSSRoutingBehavior_Side2                     2
/// **38** - Vbus Accumulated Power Option Code
#define     portVbusAccumulatedPower                            38
/// **39** - Reset Vbus Accumulated power Option Code
#define     portResetVbusAccumulatedPower                       39
/// **40** - Vconn Accumulated Power Option Code
#define     portVconnAccumulatedPower                           40
/// **41** - Reset Vconn Accumulated power Option Code
#define     portResetVconnAccumulatedPower                      41
/// **42** - Port USB 2.0 High Speed Boost Settings Option Code
#define     portHSBoost                                         42
/// **0** - -5%
#define         portHSBoost_m5Percent                               0
/// **1** - Nominal
#define         portHSBoost_Nominal                                 1
/// **2** - +5%
#define         portHSBoost_p5Percent                               2
/// **3** - +10%
#define         portHSBoost_p10Percent                              3
/// **4** - +15%
#define         portHSBoost_p15Percent                              4
/// **5** - +20%
#define         portHSBoost_p20Percent                              5
/// **6** - +25%
#define         portHSBoost_p25Percent                              6
/// **7** - +30%
#define         portHSBoost_p30Percent                              7
/// **44** - Port Reset to Factory Defaults Option Code
#define     portResetEntityToFactoryDefaults                    44
/// **45** - Port CC1 Bias Option Code
#define     portCC1State                                        45
/// **0** - None value
#define         portCC1State_None                                   0
/// **1** - Invalid value
#define         portCC1State_Invalid                                1
/// **2** - Default (500/900/1500mA) Rp  value
#define         portCC1State_RpDefault                              2
/// **3** - 1.5 Amp Rp  value
#define         portCC1State_Rp1p5                                  3
/// **4** - 3.0 Amp Rp  value
#define         portCC1State_Rp3p0                                  4
/// **5** - Rd  value
#define         portCC1State_Rd                                     5
/// **6** - Ra  value
#define         portCC1State_Ra                                     6
/// **7** - Managed by FW
#define         portCC1State_Managed                                7
/// **8** - Unknown
#define         portCC1State_Unknown                                8
/// **46** - Port CC2 State Option Code
#define     portCC2State                                        46
/// **0** - None value
#define         portCC2State_None                                   0
/// **1** - Invalid value
#define         portCC2State_Invalid                                1
/// **2** - Default (500/900/1500mA) Rp  value
#define         portCC2State_RpDefault                              2
/// **3** - 1.5 Amp Rp  value
#define         portCC2State_Rp1p5                                  3
/// **4** - 3.0 Amp Rp  value
#define         portCC2State_Rp3p0                                  4
/// **5** - Rd  value
#define         portCC2State_Rd                                     5
/// **6** - Ra  value
#define         portCC2State_Ra                                     6
/// **7** - Managed by FW
#define         portCC2State_Managed                                7
/// **8** - Unknown
#define         portCC2State_Unknown                                8
/// **47** - CC1 get voltage Option Code
#define     portCC1Voltage                                      47
/// **48** - CC1 get current Option Code
#define     portCC1Current                                      48
/// **49** - CC2 get voltage Option Code
#define     portCC2Voltage                                      49
/// **50** - CC2 get current Option Code
#define     portCC2Current                                      50
/// **51** - SBU1 get voltage Option Code
#define     portSBU1Voltage                                     51
/// **52** - SBU2 get voltage Option Code
#define     portSBU2Voltage                                     52
/// **53** - CC1 Accumulated Power Option Code
#define     portCC1AccumulatedPower                             53
/// **54** - CC2 Accumulated Power Option Code
#define     portCC2AccumulatedPower                             54
/// **55** - Number of Options for port, always last entry
#define     portNumberOfOptions                                 55

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdPOWERDELIVERY_Defines Power Delivery Command defines
 * Power Delivery Command defines.
 *
 * @{
 */

/// **36** - Power Delivery command code. 
#define cmdPOWERDELIVERY                                        36

/** \defgroup cmdPOWERDELIVERY_Command_Options Power Delivery Command options
 * \ingroup cmdPOWERDELIVERY_Defines
 *
 * @{
 */

#define     powerdeliveryPowerDataObject                        1
#define     powerdeliveryPowerDataObjectList                    2
#define     powerdeliveryPowerDataObjectEnabled                 3
#define     powerdeliveryPowerDataObjectEnabledList             4
#define     powerdeliveryNumberOfPowerDataObjects               5
#define     powerdeliveryRequestDataObject                      6
#define     powerdeliveryConnectionState                        7
#define         pdConnectionState_None                              0
#define         pdConnectionState_Source                            1
#define         pdConnectionState_Sink                              2
#define         pdConnectionState_PoweredCable                      3
#define         pdConnectionState_PoweredCableWithSink              4
#define         pdConnectionState_AudioAccessory                    5
#define         pdConnectionState_DebugAccessory                    6
#define     powerdeliveryLinkState                              8
#define         pdLinkState_linkType_Offset                         0
#define         pdLinkState_linkType_Mask                           0x7
#define             pdLinkState_linkType_None                           0
#define             pdLinkState_linkType_Legacy                         1
#define             pdLinkState_linkType_SPR                            2
#define             pdLinkState_linkType_EPR                            3
#define         pdLinkState_connectionState_Offset                  4
#define         pdLinkState_connectionState_Mask                    0xF
#define             pdLinkState_connectionState_None                    0
#define             pdLinkState_connectionState_Source                  1
#define             pdLinkState_connectionState_Sink                    2
#define             pdLinkState_connectionState_PoweredCable            3
#define             pdLinkState_connectionState_PoweredCableWithSink    4
#define             pdLinkState_connectionState_AudioAccessory          5
#define             pdLinkState_connectionState_DebugAccessory          6
#define         pdLinkState_powerRole_Offset                        8
#define         pdLinkState_powerRole_Mask                          0x7
#define             pdLinkState_powerRole_None                          0
#define             pdLinkState_powerRole_Source                        1
#define             pdLinkState_powerRole_Sink                          2
#define         pdLinkState_dataRole_Offset                         12
#define         pdLinkState_dataRole_Mask                           0x7
#define             pdLinkState_dataRole_None                           0
#define             pdLinkState_dataRole_DFP                            1
#define             pdLinkState_dataRole_UFP                            2
#define         pdLinkState_vconnState_Offset                       16
#define         pdLinkState_vconnState_Mask                         0x7
#define             pdLinkState_vconnState_Off                          0
#define             pdLinkState_vconnState_Source                       1
#define             pdLinkState_vconnState_NotSource                    2
#define         pdLinkState_specRevision_Offset                     20
#define         pdLinkState_specRevision_Mask                       0x7
#define             pdLinkState_specRevision_Unknown                    0
#define             pdLinkState_specRevision_1                          1
#define             pdLinkState_specRevision_2                          2
#define             pdLinkState_specRevision_3                          3
#define     powerdeliveryAttachTimeElapsed                      9
#define     powerdeliveryResetPowerDataObjectToDefault          15
#define     powerdeliveryCableVoltageMax                        16
#define         pdCableVoltage_Invalid                              0
#define         pdCableVoltage_20VDC                                1
#define         pdCableVoltage_30VDC                                2
#define         pdCableVoltage_40VDC                                3
#define         pdCableVoltage_50VDC                                4
#define     powerdeliveryCableCurrentMax                        17
#define         pdCableCurrent_Invalid                              0
#define         pdCableCurrent_3Amps                                1
#define         pdCableCurrent_5Amps                                2
#define     powerdeliveryCableSpeedMax                          18
#define         pdCableSpeed_Invalid                                0
#define         pdCableSpeed_USB2p0                                 1
#define         pdCableSpeed_USB3p2_Gen1                            2
#define         pdCableSpeed_USB3p2_USB4p0_Gen2                     3
#define         pdCableSpeed_USB4p0_Gen3                            4
#define         pdCableSpeed_USB4p0_Gen4                            5
#define     powerdeliveryCableType                              19
#define         pdCableType_Invalid                                 0
#define         pdCableType_Passive                                 1
#define         pdCableType_Active                                  2
#define     powerdeliveryCableOrientation                       20
#define         pdCableOrientation_Invalid                          0
#define         pdCableOrientation_CC1                              1
#define         pdCableOrientation_CC2                              2
#define     powerdeliveryPowerRoleCapabilities                  21
#define         pdPowerRoleCapabilities_None                        0
#define         pdPowerRoleCapabilities_Source                      1
#define         pdPowerRoleCapabilities_Sink                        2
#define         pdPowerRoleCapabilities_DualRole                    3
#define     powerdeliveryPowerRole                              22
#define         pdPowerRole_None                                    0
#define         pdPowerRole_Source                                  1
#define         pdPowerRole_Sink                                    2
#define         pdPowerRole_SourceSink                              3
#define     powerdeliveryPowerRolePreferred                     23
#define         pdPowerRolePreferred_None                           0
#define         pdPowerRolePreferred_Source                         1
#define         pdPowerRolePreferred_Sink                           2
#define         pdPowerRolePreferred_FollowData                     3
#define         pdPowerRolePreferred_Auto                           4
#define     powerdeliveryPeakCurrentConfiguration               24
#define     powerdeliveryFastRoleSwapCurrent                    25
#define     powerdeliveryDataRoleCapabilities                   26
#define         pdDataRoleCapabilities_None                         0
#define         pdDataRoleCapabilities_DFP                          1
#define         pdDataRoleCapabilities_UFP                          2
#define         pdDataRoleCapabilities_DualRole                     3
#define     powerdeliveryOverride                               41
#define         pdOverrideCableCurrent                              0
#define         pdOverridePortPower                                 1
#define         pdOverrideAutoDiscovery                             2
#define     powerdeliveryRequestCommand                         42
#define         pdRequestHardReset                                  0
#define         pdRequestSoftReset                                  1
#define         pdRequestDataReset                                  2
#define         pdRequestPowerRoleSwap                              3
#define         pdRequestPowerFastRoleSwap                          4
#define         pdRequestDataRoleSwap                               5
#define         pdRequestVconnSwap                                  6
#define         pdRequestSinkGoToMinimum                            7
#define         pdRequestRemoteSourcePowerDataObjects               8
#define         pdRequestRemoteSinkPowerDataObjects                 9
#define         pdRequestRemoteSourceExtendedCapabilities           10
#define         pdRequestRemoteSinkExtendedCapabilities             11
#define         pdRequestStatus                                     12
#define         pdRequestPPSStatus                                  13
#define         pdRequestBatteryCapabilities                        14
#define         pdRequestBatteryStatus                              15
#define         pdRequestManufacturerInfoSop                        16
#define         pdRequestManufacturerInfoSopp                       17
#define         pdRequestManufacturerInfoSoppp                      18
#define         pdRequestDiscoverIdentitySop                        19
#define         pdRequestDiscoverIdentitySopp                       20
#define         pdRequestDiscoverIdentitySoppp                      21
#define         pdRequestRevision                                   22
#define         pdRequestSourceInfo                                 23
#define         pdRequestCountryCode                                24
#define         pdRequestCountryInfo                                25
#define         pdRequestRemoteSourceEPRCapabilities                26
#define         pdRequestRemoteSinkEPRCapabilities                  27
#define     powerdeliveryRequestStatus                          43
#define     powerdeliveryFlagMode                               44
#define         pdFlagDualRoleData                                  1
#define         pdFlagDualRolePower                                 2
#define         pdFlagUnconstrainedPower                            3
#define         pdFlagSuspendPossible                               4
#define         pdFlagUSBComPossible                                5
#define         pdFlagUnchunkedMessageSupport                       6
#define         pdFlagHigherCapability                              7
#define         pdFlagCapabilityMismatch                            8
#define         pdFlagGivebackFlag                                  9
#define         pdFlagLast                                          10
#define     powerdeliveryLogEnable                              45
#define     powerdeliveryLogPacket                              46
#define     powerdeliveryLogEvent                               47
#define         pdEventNone                                         0
#define         pdEventPacket                                       1
#define         pdEventConnect                                      2
#define         pdEventDisconnect                                   3
#define         pdEventCableResetReceived                           4
#define         pdEventCableResetSent                               5
#define         pdEventHardResetReceived                            6
#define         pdEventHardResetSent                                7
#define         pdEventMessageTransmitFailed                        8
#define         pdEventMessageTransmitDiscarded                     9
#define         pdEventPDFunctionDisabled                           10
#define         pdEventVBUSEnabled                                  11
#define         pdEventVBUSDisabled                                 12
#define         pdEventVCONNEnabled                                 13
#define         pdEventVCONNDisabled                                14
#define         pdEventRp1A5                                        15
#define         pdEventRp3A0                                        16
#define         pdEventBistEnter                                    17
#define         pdEventBistExit                                     18
#define         pdEventInvalidPacket                                19
#define         pdEventLast                                         20
#define     powerdeliveryVDM                                    48
#define     powerdeliveryNumberOfOptions                        55

/** @} */

/** \defgroup cmdPOWERDELIVERY_Command_Constants Power Delivery Command constants
 * \ingroup cmdPOWERDELIVERY_Defines
 *
 * @{
 */

#define     powerdeliveryPartnerLocal                           0
#define     powerdeliveryPartnerRemote                          1
#define     powerdeliveryPowerRoleDisabled                      0
#define     powerdeliveryPowerRoleSource                        1
#define     powerdeliveryPowerRoleSink                          2
#define     powerdeliveryPowerRoleSourceSink                    3
/// Backwards compatibility for powerDeliveryRequestStatus
#define     powerDeliveryRequestStatus                          43
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdRAIL_Defines Rail Command defines
 * Rail Command defines.
 *
 * @{
 */

/// **32** - Rail command code. 
#define cmdRAIL                                                 32

/** \defgroup cmdRAIL_Command_Options Rail Command options
 * \ingroup cmdRAIL_Defines
 *
 * @{
 */

/// **1** - Rail Voltage Option Code
#define     railVoltage                                         1
/// **2** - Rail Current Option Code
#define     railCurrent                                         2
/// **3** - Rail Current limit Option Code
#define     railCurrentLimit                                    3
/// **4** - Rail Temperature Option Code
#define     railTemperature                                     4
/// **5** - Rail Enable Option Code
#define     railEnable                                          5
/// **6** - Rail Value Option Code
#define     railValue                                           6
/// **7** - Rail Kelvin sensing Mode Option Code
#define     railKelvinSensingEnable                             7
/// **0** - Kelvin Sensing off mode for Kelvin Sensing mode
#define         kelvinSensingOff_Value                              0
/// **1** - Kelvin Sensing on mode for Kelvin Sensing mode
#define         kelvinSensingOn_Value                               1
/// **8** - Kelving Sensing state Option Code
#define     railKelvinSensingState                              8
/// **9** - Operational Mode Option Code
#define     railOperationalMode                                 9
/// **0** - Operational Mode hardware configuration offset region (bits[0:3])
#define         railOperationalMode_HardwareConfiguration_Offset    0
/// **0** - Auto operational mode for operational mode
#define             railOperationalModeAuto_Value                       0
/// **1** - Linear mode for operational mode
#define             railOperationalModeLinear_Value                     1
/// **2** - Switcher mode for operational mode
#define             railOperationalModeSwitcher_Value                   2
/// **3** - Switcher Linear mode for operational mode
#define             railOperationalModeSwitcherLinear_Value             3
/// **4** - Operational Mode offset region (bits[4:7])
#define         railOperationalMode_Mode_Offset                     4
/// **0** - Constant Current mode for operational mode
#define             railOperationalModeConstantCurrent_Value            0
/// **1** - Constant Voltage mode for operational mode
#define             railOperationalModeConstantVoltage_Value            1
/// **2** - Constant Power mode for operational mode
#define             railOperationalModeConstantPower_Value              2
/// **3** - Constant Resistance mode for operational mode
#define             railOperationalModeConstantResistance_Value         3
/// **0xF** - Factory Reserved Operating Mode.
#define             railOperationalModeFactoryReserved_Value            0xF
/// **0** - Default operational mode for operational mode
#define         DefaultOperationalRailMode_Value                    0
/// **10** - Operational state Option Code
#define     railOperationalState                                10
/// **0** - Initializing bit for operational state
#define         railOperationalState_Initializing_Bit               0
/// **1** - Enabled bit for operational state
#define         railOperationalState_Enabled_Bit                    1
/// **2** - Fault bit for operational state
#define         railOperationalState_Fault_Bit                      2
/// **8** - Hardware Configuration region (bits[8-15]) for operational state.
#define         railOperationalState_HardwareConfiguration_Offset   8
/// **0** - Linear state for operational state option mode.
#define             railOperationalStateLinear_Value                    0
/// **1** - Switcher state for operational state option mode.
#define             railOperationalStateSwitcher_Value                  1
/// **2** - Switcher Linear state for operational state option mode.
#define             railOperationalStateSwitcherLinear_Value            2
/// **16** - Over Voltage Fault bit for operational state option mode.
#define         railOperationalStateOverVoltageFault_Bit            16
/// **17** - Under Voltage Fault bit for operational state option mode.
#define         railOperationalStateUnderVoltageFault_Bit           17
/// **18** - Over Current Fault bit for operational state option mode.
#define         railOperationalStateOverCurrentFault_Bit            18
/// **19** - Over Power Fault bit for operational state option mode.
#define         railOperationalStateOverPowerFault_Bit              19
/// **20** - Reverse Polarity Fault bit for operational state option mode.
#define         railOperationalStateReversePolarityFault_Bit        20
/// **21** - Over Temperature Fault bit for operational state option mode.
#define         railOperationalStateOverTemperatureFault_Bit        21
/// **22** - Reverse Current Fault bit for operational state option mode.
#define         railOperationalStateReverseCurrentFault_Bit         22
/// **24** - Operating Mode region (bits[24:31]) for operational state.
#define         railOperationalStateOperatingMode_Offset            24
/// **0** - Constant Current mode for operational state
#define             railOperationalStateConstantCurrent_Value           0
/// **1** - Constant Voltage mode for operational state
#define             railOperationalStateConstantVoltage_Value           1
/// **2** - Constant Power mode for operational state option codes.
#define             railOperationalStateConstantPower_Value             2
/// **3** - Constant Resistance mode for operational state
#define             railOperationalStateConstantResistance_Value        3
/// **11** - Rail Setpoint Voltage option code
#define     railVoltageSetpoint                                 11
/// **12** - Rail Setpoint Current Option Code
#define     railCurrentSetpoint                                 12
/// **13** - Rail Voltage min limit Option Code
#define     railVoltageMinLimit                                 13
/// **14** - Rail Voltage max limit Option Code
#define     railVoltageMaxLimit                                 14
/// **15** - Rail power Option Code
#define     railPower                                           15
/// **16** - Rail Setpoint power Option Code
#define     railPowerSetpoint                                   16
/// **17** - Rail power limit Option Code
#define     railPowerLimit                                      17
/// **18** - Rail resistance Option Code
#define     railResistance                                      18
/// **19** - Rail Setpoint resistance Option Code
#define     railResistanceSetpoint                              19
/// **20** - Rail Clear Fault Codes. Option Code
#define     railClearFaults                                     20
/// **21** - Number of Options for Rail, always last entry
#define     railNumberOfOptions                                 21

/** @} */

/** \defgroup cmdRAIL_Command_Constants Rail Command constants
 * \ingroup cmdRAIL_Defines
 *
 * @{
 */

/// Factory Reserved Code.
#define     railFactoryReserved                                 62
/// Factory Reserved Code.
#define     railFactoryReserved2                                63
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdRELAY_Defines Relay Command defines
 * Relay Command defines.
 *
 * @{
 */

/// **34** - Relay command code. 
#define cmdRELAY                                                34

/** \defgroup cmdRELAY_Command_Options Relay Command options
 * \ingroup cmdRELAY_Defines
 *
 * @{
 */

/// **1** - Enable Option Code
#define     relayEnable                                         1
/// **2** - Voltage Option Code
#define     relayVoltage                                        2
/// **3** - Number of Options for relay, always last entry
#define     relayNumberOfOptions                                3

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////

/** \defgroup Router_Defines Router Definitions
 *
 * @{
 */

#define     cmdMAGIC                                            0xAD
#define     cmdFORCEROUTE                                       0xAF
#define     cmdRTA                                              0x09
#define     cmdROUTE                                            0x01
#define     cmdI2C_XMIT                                         0x02
#define     cmdPARTNER_REQ                                      0xAB
#define     cmdPARTNER_RESP                                     0xA9
 

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSERVO_Defines RCServo Command defines
 * RCServo Command defines.
 *
 * @{
 */

/// **13** - RCServo command code. 
#define cmdSERVO                                                13

/** \defgroup cmdSERVO_Command_Options RCServo Command options
 * \ingroup cmdSERVO_Defines
 *
 * @{
 */

/// **1** - Enable Option Code
#define     servoEnable                                         1
/// **2** - Position Option Code
#define     servoPosition                                       2
/// **3** - Reverse Option Code
#define     servoReverse                                        3
/// **4** - Number of Options for servo, always last entry
#define     servoNumberOfOptions                                4

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSIGNAL_Defines Signal Command defines
 * Signal Command defines.
 *
 * @{
 */

/// **14** - Signal command code. 
#define cmdSIGNAL                                               14

/** \defgroup cmdSIGNAL_Command_Options Signal Command options
 * \ingroup cmdSIGNAL_Defines
 *
 * @{
 */

/// **1** - Enable Option Code
#define     signalEnable                                        1
/// **2** - Inversion of Duty Cycle Option Code
#define     signalInvert                                        2
/// **3** - Period Option Code
#define     signalT3Time                                        3
/// **4** - Active Time Option Code
#define     signalT2Time                                        4
/// **5** - Number of Options for signal, always last entry
#define     signalNumberOfOptions                               5

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSLOT_Defines Slot Command defines
 * Slot Command defines.
 *
 * @{
 */

/// **4** - Slot command code. 
#define cmdSLOT                                                 4

/** \defgroup cmdSLOT_Command_Options Slot Command options
 * \ingroup cmdSLOT_Defines
 *
 * @{
 */

/// **1** - Capacity Option Code
#define     slotCapacity                                        1
/// **2** - Size Option Code
#define     slotSize                                            2
/// **3** - Open Read Only Option Code
#define     slotOpenRead                                        3
/// **4** - Open Read Write Option Code
#define     slotOpenWrite                                       4
/// **5** - Seek Option Code
#define     slotSeek                                            5
/// **6** - Read Option Code
#define     slotRead                                            6
/// **7** - Write Option Code
#define     slotWrite                                           7
/// **8** - Close Option Code
#define     slotClose                                           8
/// **9** - Number of Options for slot, always last entry
#define     slotNumberOfOptions                                 9

/** @} */

/** \defgroup cmdSLOT_Command_Constants Slot Command constants
 * \ingroup cmdSLOT_Defines
 *
 * @{
 */

/// Bit Slot Error
#define     bitSlotError                                        0x80
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSTORE_Defines Store Command defines
 * Store Command defines.
 *
 * @{
 */

/// **77** - Store command code. 
#define cmdSTORE                                                77

/** \defgroup cmdSTORE_Command_Options Store Command options
 * \ingroup cmdSTORE_Defines
 *
 * @{
 */

/// **1** - Slot Enable Option Code
#define     storeSlotEnable                                     1
/// **2** - Slot Disable Option Code
#define     storeSlotDisable                                    2
/// **3** - Slot State Option Code
#define     storeSlotState                                      3
/// **4** - Slot Write Option Code
#define     storeWriteSlot                                      4
/// **5** - Slot Read Option Code
#define     storeReadSlot                                       5
/// **6** - Slot Close Option Code
#define     storeCloseSlot                                      6
/// **7** - Slot Lock Option Code
#define     storeLock                                           7
/// **8** - Number of Options for store, always last entry
#define     storeNumberOfOptions                                8

/** @} */

/** \defgroup cmdSTORE_Command_Constants Store Command constants
 * \ingroup cmdSTORE_Defines
 *
 * @{
 */

/// Internal Store Type
#define     storeInternalStore                                  0
/// RAM Store Type
#define     storeRAMStore                                       1
/// SD Store Type
#define     storeSDStore                                        2
/// EEPROM Store Type
#define     storeEEPROMStore                                    3
/// Maximum Store Type Index
#define     storeMaxStoreIndex                                  3
 
/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSTREAM_Defines Stream Command defines
 * Stream Command defines.
 *
 * @{
 */

/// **93** - Stream command code. 
#define cmdSTREAM                                               93

/** \defgroup cmdSTREAM_Command_Options Stream Command options
 * \ingroup cmdSTREAM_Defines
 *
 * @{
 */

/// **1** - Enable Stream Key Option Code
#define     streamEnable                                        1
/// **2** - Disable Stream Key Option Code
#define     streamDisable                                       2
/// **3** - Stream Key Capacity Option Code
#define     streamCapacity                                      3
/// **4** - Number of Options for stream, always last entry
#define     streamNumberOfOptions                               4

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdSYSTEM_Defines System Command defines
 * System Command defines.
 *
 * @{
 */

/// **3** - System command code. 
#define cmdSYSTEM                                               3

/** \defgroup cmdSYSTEM_Command_Options System Command options
 * \ingroup cmdSYSTEM_Defines
 *
 * @{
 */

/// **1** - Module address Option Code
#define     systemModule                                        1
/// **2** - Router address Option Code
#define     systemRouter                                        2
/// **3** - Heartbeat interval Option Code
#define     systemHBInterval                                    3
/// **4** - User LED Option Code
#define     systemLED                                           4
/// **5** - Sleep Option Code
#define     systemSleep                                         5
/// **6** - Boot Slot Option Code
#define     systemBootSlot                                      6
/// **255** - Disable boot slot value for Boot Slot option.
#define         aSystemBootSlotNone                                 255
/// **7** - Firmware Version Option Code
#define     systemVersion                                       7
/// **8** - Model Option Code
#define     systemModel                                         8
/// **9** - Serial Number Option Code
#define     systemSerialNumber                                  9
/// **10** - System save Option Code
#define     systemSave                                          10
/// **11** - System reset Option Code
#define     systemReset                                         11
/// **12** - Input voltage Option Code
#define     systemInputVoltage                                  12
/// **13** - Module Offset Option Code
#define     systemModuleHardwareOffset                          13
/// **14** - Module Base address Option Code
#define     systemModuleBaseAddress                             14
/// **15** - Module Software offset Option Code
#define     systemModuleSoftwareOffset                          15
/// **16** - Router address setting Option Code
#define     systemRouterAddressSetting                          16
/// **17** - IP configuration setting option code
#define     systemIPConfiguration                               17
/// **0** - DHCP Configuration
#define         systemIPModeDHCP                                    0
/// **1** - Static Configuration
#define         systemIPModeStatic                                  1
/// **0** - Default Configuration
#define         systemIPModeDefault                                 0
/// **18** - IP address setting option code
#define     systemIPAddress                                     18
/// **19** - Static IP address setting option code
#define     systemIPStaticAddressSetting                        19
/// **20** - Route to me setting option code
#define     systemRouteToMe                                     20
/// **21** - Input current Option Code
#define     systemInputCurrent                                  21
/// **22** - System uptime Option Code
#define     systemUptime                                        22
/// **23** - System max temperature Option Code
#define     systemMaxTemperature                                23
/// **24** - System log events Option Code
#define     systemLogEvents                                     24
/// **25** - Unregulated System Voltage Option Code
#define     systemUnregulatedVoltage                            25
/// **26** - Unregulated System Current Option Code
#define     systemUnregulatedCurrent                            26
/// **27** - System temperature option code
#define     systemTemperature                                   27
/// **28** - System min temperature option code
#define     systemMinTemperature                                28
/// **29** - System input power source option code
#define     systemInputPowerSource                              29
/// **30** - System input power behavior option code
#define     systemInputPowerBehavior                            30
/// **31** - System input power behavior config option code
#define     systemInputPowerBehaviorConfig                      31
/// **32** - System name option code
#define     systemName                                          32
/// **33** - System power limit option code
#define     systemPowerLimit                                    33
/// **34** - System power limit max option code
#define     systemPowerLimitMax                                 34
/// **35** - System power limit state option code
#define     systemPowerLimitState                               35
#define     systemResetEntityToFactoryDefaults                  36
#define     systemResetDeviceToFactoryDefaults                  37
/// **38** - Setting the link interface for control Option Code
#define     systemLinkInterface                                 38
/// **0** - System Link is automatically defined
#define         systemLinkAuto                                      0
/// **1** - System Link through control port
#define         systemLinkUSBControl                                1
/// **2** - System Link through the Hub (upstream connection)
#define         systemLinkUSBHub                                    2
/// **3** - System Link through the all available connections
#define         systemLinkUSBAll                                    3
/// **39** - Reserved Option Code for Acroname Internal Use Only Option Code
#define     systemReserved                                      39
/// **40** - Hardware Version option code
#define     systemHardwareVersion                               40
/// **41** - System Error option code
#define     systemErrors                                        41
/// **0** - Thermal Protection bit for operational Errors
#define         systemErrors_ThermalProtection_Bit                  0
/// **1** - Output Power Protection bit for operational Errors
#define         systemErrors_OutputPowerProtection_Bit              1
/// **42** - System LED Brightness option code
#define     systemLEDMaxBrightness                              42
/// **43** - Firmware build option code
#define     systemBuild                                         43
/// **45** - Firmware protocol features Option Code
#define     systemProtocolFeatures                              45
/// **31** - Defines bit if the protocol supports pooling of brainstem packets into a single USB frame.
#define         systemProtocolFeatures_pooledPackets_Bit            31
/// **46** - Number of Options for System, always last entry
#define     systemNumberOfOptions                               46

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdTEMPERATURE_Defines Temperature Command defines
 * Temperature Command defines.
 *
 * @{
 */

/// **33** - Temperature command code. 
#define cmdTEMPERATURE                                          33

/** \defgroup cmdTEMPERATURE_Command_Options Temperature Command options
 * \ingroup cmdTEMPERATURE_Defines
 *
 * @{
 */

/// **1** - Temperature Value Option Code
#define     temperatureMicroCelsius                             1
/// **2** - Minimum Recorded Temperature Option Code
#define     temperatureMinimumMicroCelsius                      2
/// **3** - Maximum Recorded Temperature Option Code
#define     temperatureMaximumMicroCelsius                      3
/// **4** - Temperature Logged Value reset option code
#define     temperatureResetLoggedValues                        4
/// **5** - Number of Options for temperature, always last entry
#define     temperatureNumberOfOptions                          5

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdTIMER_Defines Timer Command defines
 * Timer Command defines.
 *
 * @{
 */

/// **79** - Timer command code. 
#define cmdTIMER                                                79

/** \defgroup cmdTIMER_Command_Options Timer Command options
 * \ingroup cmdTIMER_Defines
 *
 * @{
 */

/// **1** - Expiration Value Option Code
#define     timerExpiration                                     1
/// **2** - Mode Option Code
#define     timerMode                                           2
/// **0** - Single Shot Mode
#define         timerModeSingle                                     0
/// **1** - Repeated Mode
#define         timerModeRepeat                                     1
/// **0** - Default Mode
#define         DefaultTimerMode                                    0
/// **3** - Number of Options for timer, always last entry
#define     timerNumberOfOptions                                3

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdUART_Defines UART Command defines
 * UART Command defines.
 *
 * @{
 */

/// **35** - UART command code. 
#define cmdUART                                                 35

/** \defgroup cmdUART_Command_Options UART Command options
 * \ingroup cmdUART_Defines
 *
 * @{
 */

/// **1** - Enable Option Code
#define     uartEnable                                          1
/// **2** - Baud Rate Option Code
#define     uartBaudRate                                        2
/// **0** - Automatically Selected Baud Rate
#define         uartBaudRate_Auto_Value                             0
/// **3** - Protocol Option Code
#define     uartProtocol                                        3
/// **0** - Not Yet Defined Protocol
#define         uartProtocol_Undefined                              0
/// **1** - Extron Responder (backward compatiblity)
#define         uartProtocol_Extron_Value                           1
/// **1** - Extron Responder
#define         uartProtocol_ExtronResponder_Value                  1
/// **2** - Brainstem Transport
#define         uartProtocol_Brainstem_Value                        2
/// **3** - Extron Initator
#define         uartProtocol_ExtronInitiator_Value                  3
/// **4** - Reserved
#define         uartProtocol_Reserved4_Value                        4
/// **5** - Reserved
#define         uartProtocol_Reserved5_Value                        5
/// **6** - Loopback
#define         uartProtocol_Loopback_Value                         6
/// **4** - UART Linked Channel Option Code
#define     uartLinkChannel                                     4
/// **5** - UART Stop Bits Option Code
#define     uartStopBits                                        5
/// **0** - 1 Stop Bit
#define         uartStopBits_1_Value                                0
/// **1** - 1.5 Stop Bits
#define         uartStopBits_1p5_Value                              1
/// **2** - 2 Stop Bits
#define         uartStopBits_2_Value                                2
/// **6** - UART Parity Option Code
#define     uartParity                                          6
/// **0** - No Parity Bit
#define         uartParity_None_Value                               0
/// **1** - Odd Parity Bit
#define         uartParity_Odd_Value                                1
/// **2** - Even Parity Bit
#define         uartParity_Even_Value                               2
/// **3** - Mark Parity Bit
#define         uartParity_Mark_Value                               3
/// **4** - Space Parity Bit
#define         uartParity_Space_Value                              4
/// **7** - UART Data Bits per Character Option Code
#define     uartDataBits                                        7
/// **8** - UART Flow Control Option Code
#define     uartFlowControl                                     8
/// **0** - RTS/CTS Enable
#define         uartFlowControl_RTS_CTS_Bit                         0
/// **1** - DSR/DTR Enable
#define         uartFlowControl_DSR_DTR_Bit                         1
/// **2** - XON/XOFF Enable
#define         uartFlowControl_XON_XOFF_Bit                        2
/// **9** - Option Code for UART Capable Protocols
#define     uartCapableProtocols                                9
/// **10** - Option Code for UART Available Protocols
#define     uartAvailableProtocols                              10
/// **11** - Number of Options for UART, always last entry
#define     uartNumberOfOptions                                 11

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdUPGRADE_Defines Upgrade Command defines
 * Upgrade Command defines.
 *
 * @{
 */

/// **95** - Upgrade command code.  For internal use only.
#define cmdUPGRADE                                              95


/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdUSB_Defines USB Command defines
 * USB Command defines.
 *
 * @{
 */

/// **18** - USB command code. 
#define cmdUSB                                                  18

/** \defgroup cmdUSB_Command_Options USB Command options
 * \ingroup cmdUSB_Defines
 *
 * @{
 */

/// **1** - Port Enable Option Code
#define     usbPortEnable                                       1
/// **2** - Port Disable Option Code
#define     usbPortDisable                                      2
/// **3** - Data Enable Option Code
#define     usbDataEnable                                       3
/// **4** - Data Disable Option Code
#define     usbDataDisable                                      4
/// **5** - Power Enable Option Code
#define     usbPowerEnable                                      5
/// **6** - Power Disable Option Code
#define     usbPowerDisable                                     6
/// **7** - Port Current Option Code
#define     usbPortCurrent                                      7
/// **8** - Port Voltage Option Code
#define     usbPortVoltage                                      8
/// **9** - Hub Mode Option Code
#define     usbHubMode                                          9
/// **12** - Hub Clear Error Status Option Code
#define     usbPortClearErrorStatus                             12
/// **14** - Upstream Mode Option Code
#define     usbUpstreamMode                                     14
/// **2** - UpstreamMode Auto for upstream mode
#define         usbUpstreamModeAuto                                 2
/// **0** - UpstreamMode Port 0 for upstream mode
#define         usbUpstreamModePort0                                0
/// **1** - UpstreamMode Port 1 for upstream mode
#define         usbUpstreamModePort1                                1
/// **255** - UpstreamMode None to turn off all upstream connections.
#define         usbUpstreamModeNone                                 255
/// **2** - UpstreamMode default for upstream mode
#define         usbUpstreamModeDefault                              2
/// **15** - UpstreamState Option Code
#define     usbUpstreamState                                    15
/// **2** - UpstreamMode Auto for upstream mode
#define         usbUpstreamStateNone                                2
/// **0** - UpstreamMode Port 0 for upstream mode
#define         usbUpstreamStatePort0                               0
/// **1** - UpstreamMode Port 1 for upstream mode
#define         usbUpstreamStatePort1                               1
/// **16** - Downstream ports enumeration delay Option Code
#define     usbHubEnumerationDelay                              16
/// **17** - Set or get the port current limit Option Code
#define     usbPortCurrentLimit                                 17
/// **18** - Set/Get upstream boost mode. Option Code
#define     usbUpstreamBoostMode                                18
/// **19** - Set/Get downstream boost mode. Option Code
#define     usbDownstreamBoostMode                              19
/// **0** - Boost mode off, no boost.
#define         usbBoostMode_0                                      0
/// **1** - Boost mode 4%.
#define         usbBoostMode_4                                      1
/// **2** - Boost mode 8%.
#define         usbBoostMode_8                                      2
/// **3** - Boost mode 12%.
#define         usbBoostMode_12                                     3
/// **20** - Set/Get Port mode (bit-packed) Option Code
#define     usbPortMode                                         20
/// **0** - Standard Downstream port (0.5 Amp).
#define         usbPortMode_sdp                                     0
/// **1** - Charging Downstream port (2.1 Amp).
#define         usbPortMode_cdp                                     1
/// **2** - Trickle changing functionality.
#define         usbPortMode_charging                                2
/// **3** - Electrical pasthrough of VBUS.
#define         usbPortMode_passive                                 3
/// **4** - USB2 dataline A side enabled.
#define         usbPortMode_USB2AEnable                             4
/// **5** - USB2 dataline B side enabled.
#define         usbPortMode_USB2BEnable                             5
/// **6** - USB VBUS enabled.
#define         usbPortMode_VBusEnable                              6
/// **7** - USB SS Speed dataline side A enabled.
#define         usbPortMode_SuperSpeed1Enable                       7
/// **8** - USB SS Speed dataline side B enabled.
#define         usbPortMode_SuperSpeed2Enable                       8
/// **9** - USB2 Boost Mode Enabled.
#define         usbPortMode_USB2BoostEnable                         9
/// **10** - USB3 Boost Mode Enabled.
#define         usbPortMode_USB3BoostEnable                         10
/// **11** - Auto-connect Mode Enabled.
#define         usbPortMode_AutoConnectEnable                       11
/// **12** - CC1 Enabled.
#define         usbPortMode_CC1Enable                               12
/// **13** - CC2 Enabled.
#define         usbPortMode_CC2Enable                               13
/// **14** - SBU1 Enabled.
#define         usbPortMode_SBUEnable                               14
/// **15** - Flip CC1 and CC2.
#define         usbPortMode_CCFlipEnable                            15
/// **16** - Flip Super speed data lines
#define         usbPortMode_SSFlipEnable                            16
/// **17** - Flip Side Band Unit lines.
#define         usbPortMode_SBUFlipEnable                           17
/// **18** - Flip Side Band Unit lines.
#define         usbPortMode_USB2FlipEnable                          18
/// **19** - Internal Use.
#define         usbPortMode_CC1InjectEnable                         19
/// **20** - Internal Use.
#define         usbPortMode_CC2InjectEnable                         20
/// **21** - Hi-Speed Data Enable Option Code
#define     usbHiSpeedDataEnable                                21
/// **22** - Hi-Speed Data Disable Option Code
#define     usbHiSpeedDataDisable                               22
/// **23** - SuperSpeed Data Enable Option Code
#define     usbSuperSpeedDataEnable                             23
/// **24** - SuperSpeed Data Disable Option Code
#define     usbSuperSpeedDataDisable                            24
/// **25** - Get downstream port speed Option Code
#define     usbDownstreamDataSpeed                              25
/// **0** - Unknown.
#define         usbDownstreamDataSpeed_na                           0
/// **1** - Hi-Speed (2.0).
#define         usbDownstreamDataSpeed_hs                           1
/// **2** - SuperSpeed (3.0).
#define         usbDownstreamDataSpeed_ss                           2
/// **3** - TODO
#define         usbDownstreamDataSpeed_ls                           3
/// **26** - USB connect mode Option Code
#define     usbConnectMode                                      26
/// **0** - Auto connect disabled.
#define         usbManualConnect                                    0
/// **1** - Auto connect enabled.
#define         usbAutoConnect                                      1
/// **27** - CC1 Enable option code (USB Type C). Option Code
#define     usbCC1Enable                                        27
/// **28** - CC2 Enable option code (USB Type C). Option Code
#define     usbCC2Enable                                        28
/// **29** - SBU1/2 enable option code (USB Type C). Option Code
#define     usbSBUEnable                                        29
/// **30** - CC1 get current option code (USB Type C). Option Code
#define     usbCC1Current                                       30
/// **31** - CC2 get current option code (USB Type C). Option Code
#define     usbCC2Current                                       31
/// **32** - CC1 get voltage option code (USB Type C). Option Code
#define     usbCC1Voltage                                       32
/// **33** - CC2 get voltage option code (USB Type C). Option Code
#define     usbCC2Voltage                                       33
/// **34** - TODO Option Code
#define     usbPortState                                        34
/// **35** - TODO Option Code
#define     usbPortError                                        35
/// **36** - TODO Option Code
#define     usbCableFlip                                        36
/// **37** - USB Alt Mode configuration. Option Code
#define     usbAltMode                                          37
/// **0** - Disabled mode.
#define         usbAltMode_disabled                                 0
/// **1** - Normal mode (USB 3.1).
#define         usbAltMode_normal                                   1
/// **2** - Alt Mode - 4 lanes of display port "Common" side connected to host.
#define         usbAltMode_4LaneDP_ComToHost                        2
/// **3** - Alt Mode - 4 lanes of display port "Mux" side connected to host.
#define         usbAltMode_4LaneDP_MuxToHost                        3
/// **4** - Alt Mode - 2 lanes of display port "Common" side connected to host with USB3.1.
#define         usbAltMode_2LaneDP_ComToHost_wUSB3                  4
/// **5** - Alt Mode - 2 lanes of display port "Mux" side connected to host with USB3.1.
#define         usbAltMode_2LaneDP_MuxToHost_wUSB3                  5
/// **6** - Alt Mode - 2 lanes of display port "Common" side connected to host with USB3.1 with channels 1.2 and 3,4 inverted.
#define         usbAltMode_2LaneDP_ComToHost_wUSB3_Inverted         6
/// **7** - Alt Mode - 2 lanes of display port "Mux" side connected to host with USB3.1 with channels 1.2 and 3,4 inverted.
#define         usbAltMode_2LaneDP_MuxToHost_wUSB3_Inverted         7
/// **8** - Alt Mode - USB4 with "Common" side connected to host.
#define         usbAltMode_USB4_ComToHost                           8
/// **9** - Alt Mode - USB4 with "Mux" side connected to host.
#define         usbAltMode_USB4_MuxToHost                           9
/// **10** - Alt Mode - USB4 with "Common" side connected to host, inverted configuration
#define         usbAltMode_USB4_ComToHost_Inverted                  10
/// **11** - Alt Mode - USB4 with "Mux" side connected to host, inverted configuration
#define         usbAltMode_USB4_MuxToHost_Inverted                  11
/// **38** - SBU1 get voltage option code (USB Type C). Option Code
#define     usbSBU1Voltage                                      38
/// **39** - SBU2 get voltage option code (USB Type C). Option Code
#define     usbSBU2Voltage                                      39
/// **40** - Number of Options for USB, always last entry. Option Code
#define     usbNumberOfOptions                                  40

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdUSBSYSTEM_Defines USB System Command defines
 * USB System Command defines.
 *
 * @{
 */

/// **38** - USB System command code. 
#define cmdUSBSYSTEM                                            38

/** \defgroup cmdUSBSYSTEM_Command_Options USB System Command options
 * \ingroup cmdUSBSYSTEM_Defines
 *
 * @{
 */

/// **1** - Power and Data Mode option code
#define     usbsystemPowerDataMode                              1
/// **2** - Upstream Port option code (default port is 0) Option Code
#define     usbsystemUpstreamPort                               2
/// **255** - UpstreamPort None to turn off all upstream connections or invalid state.
#define         usbsystemUpstreamPortNone                           255
/// **3** - Enumeration Delay option code
#define     usbsystemEnumerationDelay                           3
/// **4** - Data Role List option code
#define     usbsystemDataRoleList                               4
/// **5** - Enabled List option code
#define     usbsystemEnabledList                                5
/// **6** - Mode List option code
#define     usbsystemModeList                                   6
/// **7** - State List option code
#define     usbsystemStateList                                  7
/// **8** - Power behavior option code
#define     usbsystemPowerBehavior                              8
/// **0** - usbsystemPowerBehavior - Balancing between active ports
#define         usbsystemPowerBehavior_Balancing                    0
/// **1** - usbsystemPowerBehavior - Even between all ports
#define         usbsystemPowerBehavior_Even                         1
/// **9** - Power behavior config option code
#define     usbsystemPowerBehaviorConfig                        9
/// **10** - Data behavior option code
#define     usbsystemDataBehavior                               10
/// **0** - usbsystemDataBehavior - HardCoded ports
#define         usbsystemDataBehavior_HardCoded                     0
/// **1** - usbsystemDataBehavior - FollowPD
#define         usbsystemDataBehavior_FollowPD                      1
/// **2** - usbsystemDataBehavior - Use port priority
#define         usbsystemDataBehavior_PortPriority                  2
/// **3** - usbsystemDataBehavior - Most Recently Connected Upstream
#define         usbsystemDataBehavior_LastConnected                 3
/// **11** - Data behavior config option code
#define     usbsystemDataBehaviorConfig                         11
/// **12** - Selector mode option code
#define     usbsystemSelectorMode                               12
/// **0** - Selector Disabled
#define         usbsystemSelectorMode_Disabled                      0
/// **1** - Selector Upstream - Toggles through upstreams
#define         usbsystemSelectorMode_Upstream                      1
/// **2** - Selector Mux - Toggles through mux ports
#define         usbsystemSelectorMode_Mux                           2
/// **13** - Resets USBSystem reset to default option code.
#define     usbsystemResetEntityToFactoryDefaults               13
/// **14** - Behavior overrides for USB System Option Code
#define     usbsystemOverride                                   14
/// **0** - USB System Override - Auto VBUS Toggle Disable Bit
#define         usbsystemOverride_AutoVbusToggle_Bit                0
/// **1** - USB System Override - VBUS Detect Disable Bit
#define         usbsystemOverride_VbusDetect_Bit                    1
/// **15** - Upstream Port option code (default port is 0) Option Code
#define     usbsystemUpstreamHSPort                             15
/// **16** - Upstream Port option code (default port is 0) Option Code
#define     usbsystemUpstreamSSPort                             16
/// **17** - Max HighSpeed Data Rate that can be negotiated Option Code
#define     usbsystemDataHSMaxDatarate                          17
/// **0** - Max HighSpeed Data Rate of None 0Mbps
#define         usbsystemDataHSMaxDatarate_None                     0
/// **1** - Max HighSpeed Data Rate of Low Speed 1.5Mbps
#define         usbsystemDataHSMaxDatarate_LowSpeed                 1
/// **2** - Max HighSpeed Data Rate of Full Speed 12Mbps
#define         usbsystemDataHSMaxDatarate_FullSpeed                2
/// **3** - Max HighSpeed Data Rate of High Speed 480Mbps
#define         usbsystemDataHSMaxDatarate_HighSpeed                3
/// **18** - Max SuperSpeed Data Rate that can be negotiated Option Code
#define     usbsystemDataSSMaxDatarate                          18
/// **0** - Max SuperSpeed Data Rate of None 0Gbps
#define         usbsystemDataSSMaxDatarate_None                     0
/// **1** - Max SuperSpeed Data Rate of Super Speed 5Gbps (Gen 1)
#define         usbsystemDataSSMaxDatarate_SuperSpeed               1
/// **2** - Max SuperSpeed Data Rate of Super Speed 10Gbps (Gen 2)
#define         usbsystemDataSSMaxDatarate_SuperSpeedPlus           2
/// **19** - Number of Options for USB System, always last entry
#define     usbsystemNumberOfOptions                            19

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////
/** \defgroup cmdUSERCONFIG_Defines UserConfig Command defines
 * UserConfig Command defines.
 *
 * @{
 */

/// **92** - UserConfig command code. 
#define cmdUSERCONFIG                                           92

/** \defgroup cmdUSERCONFIG_Command_Options UserConfig Command options
 * \ingroup cmdUSERCONFIG_Defines
 *
 * @{
 */

/// **0** - Save Entity option code.
#define     userconfigSaveEntityToStore                         0
/// **1** - Reset Entity to factory defaults option code.
#define     userconfigResetEntityToFactoryDefaults              1
/// **2** - Load Entity from saved values option code.
#define     userconfigLoadEntityFromStore                       2
/// **3** - Number of Options for UserConfig, always last entry
#define     userconfigNumberOfOptions                           3

/** @} */

/** @} */
/////////////////////////////////////////////////////////////////////

#endif // _autoGen_aProtocolDefs_H_