/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: PortMapping_CCA.h
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////
#ifndef __PortMapping_CCA_H__
#define __PortMapping_CCA_H__

#include "CCA_Core.h"

typedef enum {
    kPORT_SPEED_UNKNOWN_CCA = 0,    /**< kPORT_SPEED_UNKNOWN (0)*/
    kPORT_SPEED_LOW_CCA,            /**< kPORT_SPEED_LOW (1)*/
    kPORT_SPEED_FULL_CCA,           /**< kPORT_SPEED_FULL (2)*/
    kPORT_SPEED_HIGH_CCA,           /**< kPORT_SPEED_HIGH (3)*/
    kPORT_SPEED_SUPER_CCA,          /**< kPORT_SPEED_SUPER (4)*/
    kPORT_SPEED_SUPER_PLUS_CCA,     /**< kPORT_SPEED_SUPER_PLUS (5)*/
} PORT_SPEED_CCA_t;


#ifdef CCA_PACK
    #pragma pack(push, CCA_PACK)
#endif

/** Device Node Structure - Contains information linking the downstream
 *  device to the Acroname Hub. */
struct DeviceNode_CCA {
    //Acroname Device Information
    unsigned int hubSerialNumber; /**< Serial number of the Acroname hub where the device was found.*/
    unsigned char hubPort;/**< Port of the Acroname hub where the device was found.*/

    //Downstream device information.
    unsigned short idVendor;/**< Manufactures Vendor ID of the downstream device.*/
    unsigned short idProduct;/**< Manufactures Product ID of the downstream device.*/
    unsigned char speed;/**< The devices downstream device speed. (PORT_SPEED_CCA_t)*/
    char productName[255];/**< USB string descriptor*/
    char serialNumber[255];/**< USB string descriptor*/
    char manufacturer[255];/**< USB string descriptor*/
};
#ifdef CCA_PACK
    #pragma pack(pop)
#endif


/// \defgroup PortMapping PortMapping Class
/// PortMapping Class:
/// Provides an interface for usb descriptor information of devices downstream
/// of Acroname hub products.
///

#ifdef __cplusplus
extern "C" {
#endif


    /////////////////////////////////////////////////////////////////////
    /// Gets downstream device USB information for all Acroname hubs.
    /// \param result Object containing aErrNone and the requested value on success.
    /// Non-zero error code on failure.
    ///    The number of devices found.
    /// \param buffer Pointer to the start of a list/array to be used by the function.
    /// \param bufferLength Size of the list/array in DeviceNode_CCA's, not bytes.
    /// \details ::aErrNone on success
    /// \details ::aErrParam: Passed in values are not valid. (NULL, size etc).
    /// \details ::aErrMemory: No more room in the list
    /// \details ::aErrNotFound: No Acroname devices were found.
    aLIBEXPORT void __stdcall portMapping_getDownstreamDevices(struct Result* result, struct DeviceNode_CCA* buffer, const unsigned int bufferLength);

#ifdef __cplusplus
}
#endif

#endif
