/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: aError_CCA.h
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2024 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////
#ifndef __aError_CCA_H__
#define __aError_CCA_H__

#include "CCA_Core.h"

#ifdef __cplusplus
extern "C" {
#endif

    /// \defgroup Error Errors


    /////////////////////////////////////////////////////////////////////
   /// Returns a printable error string.
    aLIBEXPORT void __stdcall error_GetErrorText(struct Result* result, unsigned int error, unsigned char* buffer, unsigned int bufferLength);

    /////////////////////////////////////////////////////////////////////
    /// Returns a printable error description.
    aLIBEXPORT void __stdcall error_GetErrorDescription(struct Result* result, unsigned int error, unsigned char* buffer, unsigned int bufferLength);

#ifdef __cplusplus
}
#endif

#endif
