/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_AnalogClass_CCA.h                                 //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_ANALOG_CCA_H__
#define __AUTOGEN_ANALOG_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup AnalogEntity Analog Entity
/// Interface to analog entities on BrainStem modules.
/// Analog entities may be configured as a input or output depending on hardware capabilities.
/// Some modules are capable of providing actual voltage readings, while other simply return
///   the raw analog-to-digital converter (ADC) output value.
/// The resolution of the voltage or number of useful bits is also hardware dependent.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the raw ADC output value in bits.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 16 bit analog reading with 0 corresponding to the negative analog voltage
///              reference and 0xFFFF corresponding to the positive analog voltage reference.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
/// \note Not all modules are provide 16 useful bits; this value's least significant bits are
///       zero-padded to 16 bits.
///       Refer to the module's datasheet to determine analog bit depth and reference voltage.
/// 
aLIBEXPORT void __stdcall analog_getValue(unsigned int* id, struct Result* result, const int index);

/// Get the scaled micro volt value with reference to ground.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 32 bit signed integer (in microvolts) based on the board's ground and
///              reference voltages.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
/// \note Not all modules provide 32 bits of accuracy.
///       Refer to the module's datasheet to determine the analog bit depth and reference
///       voltage.
/// 
aLIBEXPORT void __stdcall analog_getVoltage(unsigned int* id, struct Result* result, const int index);

/// Get the analog input range.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 8 bit value corresponding to a discrete range option
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getRange(unsigned int* id, struct Result* result, const int index);

/// Get the analog output enable status.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: 0 if disabled 1 if enabled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getEnable(unsigned int* id, struct Result* result, const int index);

/// Set the value of an analog output (DAC) in bits.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value 16 bit analog set point with 0 corresponding to the negative analog voltage
///        reference and 0xFFFF corresponding to the positive analog voltage reference.
/// 
/// \note Not all modules are provide 16 useful bits; the least significant bits are
///       discarded.
///       E.g. for a 10 bit DAC, 0xFFC0 to 0x0040 is the useful range.
///       Refer to the module's datasheet to determine analog bit depth and reference voltage.
/// 
aLIBEXPORT void __stdcall analog_setValue(unsigned int* id, struct Result* result, const int index, const unsigned short value);

/// Set the voltage level of an analog output (DAC) in microvolts.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param microvolts 32 bit signed integer (in microvolts) based on the board's ground and
///        reference voltages.
/// 
/// \note Voltage range is dependent on the specific DAC channel range.
/// 
aLIBEXPORT void __stdcall analog_setVoltage(unsigned int* id, struct Result* result, const int index, const int microvolts);

/// Set the analog input range.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param range 8 bit value corresponding to a discrete range option
/// 
aLIBEXPORT void __stdcall analog_setRange(unsigned int* id, struct Result* result, const int index, const unsigned char range);

/// Set the analog output enable state.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param enable set 1 to enable or 0 to disable.
/// 
aLIBEXPORT void __stdcall analog_setEnable(unsigned int* id, struct Result* result, const int index, const unsigned char enable);

/// Set the analog configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param configuration bitAnalogConfigurationOutput configures the analog entity as an
///        output.
/// 
aLIBEXPORT void __stdcall analog_setConfiguration(unsigned int* id, struct Result* result, const int index, const unsigned char configuration);

/// Get the analog configuration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Current configuration of the analog entity.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getConfiguration(unsigned int* id, struct Result* result, const int index);

/// Set the sample rate for this analog when bulk capturing.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value sample rate in samples per second (Hertz).
///        - Minimum rate: 7,000 Hz
///        - Maximum rate: 200,000 Hz
/// 
aLIBEXPORT void __stdcall analog_setBulkCaptureSampleRate(unsigned int* id, struct Result* result, const int index, const unsigned int value);

/// Get the current sample rate setting for this analog when bulk capturing.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: upon success filled with current sample rate in samples per second (Hertz).
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getBulkCaptureSampleRate(unsigned int* id, struct Result* result, const int index);

/// Set the number of samples to capture for this analog when bulk capturing.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param value number of samples.
///        - Minimum # of Samples: 0
///        - Maximum # of Samples: (BRAINSTEM_RAM_SLOT_SIZE / 2) = (3FFF / 2) = 1FFF = 8191
/// 
aLIBEXPORT void __stdcall analog_setBulkCaptureNumberOfSamples(unsigned int* id, struct Result* result, const int index, const unsigned int value);

/// Get the current number of samples setting for this analog when bulk capturing.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: number of samples.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getBulkCaptureNumberOfSamples(unsigned int* id, struct Result* result, const int index);

/// Initiate a BulkCapture on this analog.
/// Captured measurements are stored in the module's RAM store (RAM_STORE) slot 0.
/// Data is stored in a contiguous byte array with each sample stored in two consecutive
///   bytes, LSB first.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// 
/// \note When the bulk capture is complete getBulkCaptureState() will return either
///       bulkCaptureFinished or bulkCaptureError.
/// 
aLIBEXPORT void __stdcall analog_initiateBulkCapture(unsigned int* id, struct Result* result, const int index);

/// Get the current bulk capture state for this analog.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: the state of bulk capture.
///              \li Idle: bulkCaptureIdle = 0
///              \li Pending: bulkCapturePending = 1
///              \li Finished: bulkCaptureFinished = 2
///              \li Error: bulkCaptureError = 3
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall analog_getBulkCaptureState(unsigned int* id, struct Result* result, const int index);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_ANALOG_CCA_H__