/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_ClockClass_CCA.h                                  //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_CLOCK_CCA_H__
#define __AUTOGEN_CLOCK_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup ClockEntity Clock Entity
/// Provides an interface to a real-time clock entity on a BrainStem module.
/// The clock entity may be used to get and set the real time of the system.
/// The clock entity has a one second resolution.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Get the four digit year value (0-4095).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Get the year portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getYear(unsigned int* id, struct Result* result, const int index);

/// Set the four digit year value (0-4095).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param year Set the year portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setYear(unsigned int* id, struct Result* result, const int index, const unsigned short year);

/// Get the two digit month value (1-12).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The two digit month portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getMonth(unsigned int* id, struct Result* result, const int index);

/// Set the two digit month value (1-12).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param month The two digit month portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setMonth(unsigned int* id, struct Result* result, const int index, const unsigned char month);

/// Get the two digit day of month value (1-28, 29, 30 or 31 depending on the month).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The two digit day portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getDay(unsigned int* id, struct Result* result, const int index);

/// Set the two digit day of month value (1-28, 29, 30 or 31 depending on the month).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param day The two digit day portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setDay(unsigned int* id, struct Result* result, const int index, const unsigned char day);

/// Get the two digit hour value (0-23).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The two digit hour portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getHour(unsigned int* id, struct Result* result, const int index);

/// Set the two digit hour value (0-23).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param hour The two digit hour portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setHour(unsigned int* id, struct Result* result, const int index, const unsigned char hour);

/// Get the two digit minute value (0-59).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The two digit minute portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getMinute(unsigned int* id, struct Result* result, const int index);

/// Set the two digit minute value (0-59).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param minute The two digit minute portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setMinute(unsigned int* id, struct Result* result, const int index, const unsigned char minute);

/// Get the two digit second value (0-59).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: The two digit second portion of the real-time clock value.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall clock_getSecond(unsigned int* id, struct Result* result, const int index);

/// Set the two digit second value (0-59).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param second The two digit second portion of the real-time clock value.
/// 
aLIBEXPORT void __stdcall clock_setSecond(unsigned int* id, struct Result* result, const int index, const unsigned char second);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_CLOCK_CCA_H__