/////////////////////////////////////////////////////////////////////
//                                                                 //
// file: autoGen_PowerDeliveryClass_CCA.h                          //
//                                                                 //
/////////////////////////////////////////////////////////////////////
//                                                                 //
// Copyright (c) 2026 Acroname Inc. - All Rights Reserved          //
//                                                                 //
// This file is part of the BrainStem release. See the license.txt //
// file included with this package or go to                        //
// https://acroname.com/software/brainstem-development-kit         //
// for full license details.                                       //
/////////////////////////////////////////////////////////////////////

#ifndef __AUTOGEN_POWERDELIVERY_CCA_H__
#define __AUTOGEN_POWERDELIVERY_CCA_H__

// This file was auto-generated. Do not modify.

#include "CCA_Core.h"

#ifdef __GNUC__
#define DEPRECATED(...) __attribute__((deprecated(__VA_ARGS__)))
#elif defined(_MSC_VER)
#define DEPRECATED(...) __declspec(deprecated(__VA_ARGS__))
#else
#define DEPRECATED(...)
#pragma message("DEPRECATED is not defined for this compiler")
#endif

/// \defgroup PowerDeliveryEntity PowerDelivery Entity
/// Power Delivery or PD is a power specification which allows more charging options and
///   device behaviors within the USB interface.
/// This Entity will allow you to directly access the vast landscape of PD.
///

#ifdef __cplusplus
extern "C" {
#endif

/// Gets the current state of the connection in the form of an enumeration.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to be filled with the current connection state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getConnectionState(unsigned int* id, struct Result* result, const int index);

/// Gets the number of Power Data Objects (PDOs) for a given partner and power role.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the number of PDOs.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///            - Local = 0 = powerdeliveryPartnerLocal
///            - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// 
aLIBEXPORT void __stdcall powerdelivery_getNumberOfPowerDataObjects(unsigned int* id, struct Result* result, const int index, const unsigned char partner, const unsigned char powerRole);

/// Gets the Power Data Object (PDO) for the requested partner, powerRole and index.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the requested power rule.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///            - Local = 0 = powerdeliveryPartnerLocal
///            - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObject(unsigned int* id, struct Result* result, const int index, const unsigned char partner, const unsigned char powerRole, const unsigned char ruleIndex);

/// Sets the Power Data Object (PDO) of the local partner for a given power role and index.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \param pdo Power Data Object to be set.
/// 
aLIBEXPORT void __stdcall powerdelivery_setPowerDataObject(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex, const unsigned int pdo);

/// Resets the Power Data Object (PDO) of the Local partner for a given power role and index.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// 
aLIBEXPORT void __stdcall powerdelivery_resetPowerDataObjectToDefault(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex);

/// Gets all Power Data Objects (PDOs).
/// Equivalent to calling PowerDeliveryClass::getPowerDataObject() on all partners, power
///   roles, and index's.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
///              On success this value should be 28 (7 rules * 2 partners * 2 power roles)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param buffer pointer to the start of a c style buffer to be filled
///        The order of which is:
///            - Rules 1-7 Local Source
///            - Rules 1-7 Local Sink
///            - Rules 1-7 Partner Source
///            - Rules 1-7 Partner Sink.
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectList(unsigned int* id, struct Result* result, const int index, unsigned int* buffer, const unsigned int bufferLength);

/// Gets the enabled state of the Local Power Data Object (PDO) for a given power role and
///   index.
/// Enabled refers to whether the PDO will be advertised when a PD connection is made.
/// This does not indicate the currently active rule index. This information can be found in
///   Request Data Object (RDO).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with enabled state.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectEnabled(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex);

/// Sets the enabled state of the Local Power Data Object (PDO) for a given powerRole and
///   index.
/// Enabled refers to whether the PDO will be advertised when a PD connection is made.
/// This does not indicate the currently active rule index. This information can be found in
///   Request Data Object (RDO).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex The index of the PDO in question. Valid index are 1-7.
/// \param enabled The state to be set.
/// 
aLIBEXPORT void __stdcall powerdelivery_setPowerDataObjectEnabled(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole, const unsigned char ruleIndex, const unsigned char enabled);

/// Gets all Power Data Object enables for a given power role.
/// Equivalent of calling PowerDeliveryClass::getPowerDataObjectEnabled() for all indexes.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with a mapped representation of the enabled PDOs for a
///              given power role.
///              Values align with a given rule index (bits 1-7, bit 0 is invalid)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param powerRole Indicates which power role of PD connection is in question.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerDataObjectEnabledList(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole);

/// Gets the current Request Data Object (RDO) for a given partner.
/// RDOs are provided by the sinking device and exist only after a successful PD negotiation
///   (Otherwise zero).
/// Only one RDO can exist at a time. i.e. Either the Local or Remote partner RDO
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the current RDO.
///              Zero indicates the RDO is not active.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param partner Indicates which side of the PD connection is in question.
///            - Local = 0 = powerdeliveryPartnerLocal
///            - Remote = 1 = powerdeliveryPartnerRemote
/// 
aLIBEXPORT void __stdcall powerdelivery_getRequestDataObject(unsigned int* id, struct Result* result, const int index, const unsigned char partner);

/// Sets the current Request Data Object (RDO) for a given partner.
/// Only the local partner can be changed.
/// RDOs are provided by the sinking device and exist only after a successful PD negotiation
///   (Otherwise zero).
/// Only one RDO can exist at a time. i.e. Either the Local or Remote partner RDO
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param rdo Request Data Object to be set.
/// 
aLIBEXPORT void __stdcall powerdelivery_setRequestDataObject(unsigned int* id, struct Result* result, const int index, const unsigned int rdo);

/// Gets the current state of the connection in the form of a bitmask.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Pointer to be filled with the current connection state bits.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getLinkState(unsigned int* id, struct Result* result, const int index);

/// Gets the length of time that the port has been in the attached state.
/// Returned as a list of two unsigned integers, first seconds, then microseconds.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Length that was actually received and filled.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param secondsAndMicroseconds Pointer to list of unsigned integers to fill with attach
///        time elapsed
/// \param bufferLength Length of the buffer to be filed
/// 
aLIBEXPORT void __stdcall powerdelivery_getAttachTimeElapsed(unsigned int* id, struct Result* result, const int index, unsigned int* secondsAndMicroseconds, const unsigned int bufferLength);

/// Gets the power roles that may be advertised by the local partner. (CC Strapping).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filed with the power role
///                  \li None = 0 = pdPowerRoleCapabilities_None
///                  \li Source = 1 = pdPowerRoleCapabilities_Source
///                  \li Sink = 2 = pdPowerRoleCapabilities_Sink
///                  \li Source/Sink = 3 = pdPowerRoleCapabilities_DualRole (Dual Role Port)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerRoleCapabilities(unsigned int* id, struct Result* result, const int index);

/// Gets the power role that is currently being advertised by the local partner. (CC
///   Strapping).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filed with the power role
///                  \li Disabled = 0 = powerdeliveryPowerRoleDisabled
///                  \li Source = 1= powerdeliveryPowerRoleSource
///                  \li Sink = 2 = powerdeliveryPowerRoleSink
///                  \li Source/Sink = 3 = powerdeliveryPowerRoleSourceSink (Dual Role Port)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerRole(unsigned int* id, struct Result* result, const int index);

/// Set the current power role to be advertised by the Local partner. (CC Strapping).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param powerRole Value to be applied.
///            - Disabled = 0 = powerdeliveryPowerRoleDisabled
///            - Source = 1= powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
///            - Source/Sink = 3 = powerdeliveryPowerRoleSourceSink (Dual Role Port)
/// 
aLIBEXPORT void __stdcall powerdelivery_setPowerRole(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole);

/// Gets the preferred power role currently being advertised by the Local partner. (CC
///   Strapping).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Value to be applied.
///                  \li Disabled = 0 = powerdeliveryPowerRoleDisabled
///                  \li Source = 1= powerdeliveryPowerRoleSource
///                  \li Sink = 2 = powerdeliveryPowerRoleSink
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPowerRolePreferred(unsigned int* id, struct Result* result, const int index);

/// Set the preferred power role to be advertised by the Local partner (CC Strapping).
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param powerRole Value to be applied.
///            - Disabled = 0 = powerdeliveryPowerRoleDisabled
///            - Source = 1= powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// 
aLIBEXPORT void __stdcall powerdelivery_setPowerRolePreferred(unsigned int* id, struct Result* result, const int index, const unsigned char powerRole);

/// Gets the data roles that may be advertised by the local partner.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filed with the data role
///                  \li None = 0 = pdDataRoleCapabilities_None
///                  \li DFP = 1 = pdDataRoleCapabilities_DFP
///                  \li UFP = 2 = pdDataRoleCapabilities_UFP
///                  \li DFP/UFP = 3 = pdDataRoleCapabilities_DualRole (Dual Role Port)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getDataRoleCapabilities(unsigned int* id, struct Result* result, const int index);

/// Gets the maximum voltage capability reported by the e-mark of the attached cable.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated representation of voltage.
///                  \li Unknown/Unattached (0)
///                  \li 20 Volts DC (1)
///                  \li 30 Volts DC (2)
///                  \li 40 Volts DC (3)
///                  \li 50 Volts DC (4)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getCableVoltageMax(unsigned int* id, struct Result* result, const int index);

/// Gets the maximum current capability report by the e-mark of the attached cable.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated representation of current.
///                  \li Unknown/Unattached (0)
///                  \li 3 Amps (1)
///                  \li 5 Amps (2)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getCableCurrentMax(unsigned int* id, struct Result* result, const int index);

/// Gets the maximum data rate capability reported by the e-mark of the attached cable.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated representation of data speed.
///                  \li Unknown/Unattached (0)
///                  \li USB 2.0 (1)
///                  \li USB 3.2 gen 1 (2)
///                  \li USB 3.2 / USB 4 gen 2 (3)
///                  \li USB 4 gen 3 (4)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getCableSpeedMax(unsigned int* id, struct Result* result, const int index);

/// Gets the cable type reported by the e-mark of the attached cable.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with an enumerated representation of the cable type.
///                  \li Invalid, no e-mark and not Vconn powered (0)
///                  \li Passive cable with e-mark (1)
///                  \li Active cable (2)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getCableType(unsigned int* id, struct Result* result, const int index);

/// Gets the current orientation being used for PD communication
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable filled with an enumeration of the orientation.
///                  \li Unconnected (0)
///                  \li CC1 (1)
///                  \li CC2 (2)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getCableOrientation(unsigned int* id, struct Result* result, const int index);

/// Requests an action of the Remote partner.
/// Actions are not guaranteed to occur.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param request Request to be issued to the remote partner
///            - pdRequestHardReset (0)
///            - pdRequestSoftReset (1)
///            - pdRequestDataReset (2)
///            - pdRequestPowerRoleSwap (3)
///            - pdRequestPowerFastRoleSwap (4)
///            - pdRequestDataRoleSwap (5)
///            - pdRequestVconnSwap (6)
///            - pdRequestSinkGoToMinimum (7)
///            - pdRequestRemoteSourcePowerDataObjects (8)
///            - pdRequestRemoteSinkPowerDataObjects (9)
/// 
aLIBEXPORT void __stdcall powerdelivery_request(unsigned int* id, struct Result* result, const int index, const unsigned char request);

/// Gets the status of the last request command sent.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the status
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_requestStatus(unsigned int* id, struct Result* result, const int index);

/// Gets the current enabled overrides
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Bit mapped representation of the current override configuration.
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getOverride(unsigned int* id, struct Result* result, const int index);

/// Sets the current enabled overrides
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param overrides Overrides to be set in a bit mapped representation.
/// 
aLIBEXPORT void __stdcall powerdelivery_setOverride(unsigned int* id, struct Result* result, const int index, const unsigned int overrides);

/// Gets the current mode of the local partner flag/advertisement.
/// These flags are apart of the first Local Power Data Object and must be managed in order to
///   accurately represent the system to other PD devices.
/// This API allows overriding of that feature. Overriding may lead to unexpected behaviors.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with the current mode.
///                  \li Disabled (0)
///                  \li Enabled (1)
///                  \li Auto (2) default
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// \param flag Flag/Advertisement to be modified
/// 
aLIBEXPORT void __stdcall powerdelivery_getFlagMode(unsigned int* id, struct Result* result, const int index, const unsigned char flag);

/// Sets how the local partner flag/advertisement is managed.
/// These flags are apart of the first Local Power Data Object and must be managed in order to
///   accurately represent the system to other PD devices.
/// This API allows overriding of that feature. Overriding may lead to unexpected behaviors.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param flag Flag/Advertisement to be modified
/// \param mode Value to be applied.
///            - Disabled (0)
///            - Enabled (1)
///            - Auto (2) default
/// 
aLIBEXPORT void __stdcall powerdelivery_setFlagMode(unsigned int* id, struct Result* result, const int index, const unsigned char flag, const unsigned char mode);

/// Gets the Peak Current Configuration for the Local Source.
/// The peak current configuration refers to the allowable tolerance/overload capabilities in
///   regards to the devices max current.
/// This tolerance includes a maximum value and a time unit.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: An enumerated value referring to the current configuration.
///                  \li Allowable values are 0 - 4
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getPeakCurrentConfiguration(unsigned int* id, struct Result* result, const int index);

/// Sets the Peak Current Configuration for the Local Source.
/// The peak current configuration refers to the allowable tolerance/overload capabilities in
///   regards to the devices max current.
/// This tolerance includes a maximum value and a time unit.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param configuration An enumerated value referring to the configuration to be set
///            - Allowable values are 0 - 4
/// 
aLIBEXPORT void __stdcall powerdelivery_setPeakCurrentConfiguration(unsigned int* id, struct Result* result, const int index, const unsigned char configuration);

/// Gets the Fast Role Swap Current
/// The fast role swap current refers to the amount of current required by the Local Sink in
///   order to successfully preform the swap.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: An enumerated value referring to current swap value.
///                  \li 0A (0)
///                  \li 900mA (1)
///                  \li 1.5A (2)
///                  \li 3A (3)
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code and the requested value if successful.
/// \param index The index of the entity in question.
/// 
aLIBEXPORT void __stdcall powerdelivery_getFastRoleSwapCurrent(unsigned int* id, struct Result* result, const int index);

/// Sets the Fast Role Swap Current
/// The fast role swap current refers to the amount of current required by the Local Sink in
///   order to successfully preform the swap.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param id ID assigned through "module_createStem"
/// \param result Output object containing result code.
/// \param index The index of the entity in question.
/// \param swapCurrent An enumerated value referring to value to be set.
///            - 0A (0)
///            - 900mA (1)
///            - 1.5A (2)
///            - 3A (3)
/// 
aLIBEXPORT void __stdcall powerdelivery_setFastRoleSwapCurrent(unsigned int* id, struct Result* result, const int index, const unsigned char swapCurrent);

/// Helper function for packing Data Object attributes.
/// This value is used as a subindex for all Data Object calls with the BrainStem Protocol.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
///     \li value: Variable to be filled with packed values.
/// 
/// \param result Output object containing result code and the requested value if successful.
/// \param partner Indicates which side of the PD connection.
///            - Local = 0 = powerdeliveryPartnerLocal
///            - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex Data object index.
/// 
aLIBEXPORT void __stdcall powerdelivery_packDataObjectAttributes(struct Result* result, const unsigned char partner, const unsigned char powerRole, const unsigned char ruleIndex);

/// Helper function for unpacking Data Object attributes.
/// This value is used as a subindex for all Data Object calls with the BrainStem Protocol.
/// 
/// The result parameter will output the following fields:
///     \li error: \ref EntityReturnValues common entity return value
/// 
/// \param result Output object containing result code.
/// \param attributes Variable to be filled with packed values.
/// \param partner Indicates which side of the PD connection.
///            - Local = 0 = powerdeliveryPartnerLocal
///            - Remote = 1 = powerdeliveryPartnerRemote
/// \param powerRole Indicates which power role of PD connection.
///            - Source = 1 = powerdeliveryPowerRoleSource
///            - Sink = 2 = powerdeliveryPowerRoleSink
/// \param ruleIndex Data object index.
/// 
aLIBEXPORT void __stdcall powerdelivery_unpackDataObjectAttributes(struct Result* result, const unsigned char attributes, unsigned char* partner, unsigned char* powerRole, unsigned char* ruleIndex);


#ifdef __cplusplus
}
#endif

#endif // __AUTOGEN_POWERDELIVERY_CCA_H__